/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery;

import com.oracle.bmc.recovery.DatabaseRecovery;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.requests.GetProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.GetProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.recovery.responses.GetProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.GetProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.GetRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DatabaseRecoveryWaiters {
    private final ExecutorService executorService;
    private final DatabaseRecovery client;

    public DatabaseRecoveryWaiters(ExecutorService executorService, DatabaseRecovery client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetProtectedDatabaseRequest, GetProtectedDatabaseResponse> forProtectedDatabase(GetProtectedDatabaseRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProtectedDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProtectedDatabaseRequest, GetProtectedDatabaseResponse> forProtectedDatabase(GetProtectedDatabaseRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProtectedDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProtectedDatabaseRequest, GetProtectedDatabaseResponse> forProtectedDatabase(GetProtectedDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProtectedDatabase(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProtectedDatabaseRequest, GetProtectedDatabaseResponse> forProtectedDatabase(BmcGenericWaiter waiter, GetProtectedDatabaseRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProtectedDatabaseRequest, GetProtectedDatabaseResponse>(){

            @Override
            public GetProtectedDatabaseResponse apply(GetProtectedDatabaseRequest request) {
                return DatabaseRecoveryWaiters.this.client.getProtectedDatabase(request);
            }
        }, (Predicate)new Predicate<GetProtectedDatabaseResponse>(){

            @Override
            public boolean test(GetProtectedDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getProtectedDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetProtectionPolicyRequest, GetProtectionPolicyResponse> forProtectionPolicy(GetProtectionPolicyRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProtectionPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProtectionPolicyRequest, GetProtectionPolicyResponse> forProtectionPolicy(GetProtectionPolicyRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProtectionPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProtectionPolicyRequest, GetProtectionPolicyResponse> forProtectionPolicy(GetProtectionPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProtectionPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProtectionPolicyRequest, GetProtectionPolicyResponse> forProtectionPolicy(BmcGenericWaiter waiter, GetProtectionPolicyRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetProtectionPolicyRequest, GetProtectionPolicyResponse>(){

            @Override
            public GetProtectionPolicyResponse apply(GetProtectionPolicyRequest request) {
                return DatabaseRecoveryWaiters.this.client.getProtectionPolicy(request);
            }
        }, (Predicate)new Predicate<GetProtectionPolicyResponse>(){

            @Override
            public boolean test(GetProtectionPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getProtectionPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRecoveryServiceSubnetRequest, GetRecoveryServiceSubnetResponse> forRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRecoveryServiceSubnet(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRecoveryServiceSubnetRequest, GetRecoveryServiceSubnetResponse> forRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRecoveryServiceSubnet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRecoveryServiceSubnetRequest, GetRecoveryServiceSubnetResponse> forRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRecoveryServiceSubnet(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRecoveryServiceSubnetRequest, GetRecoveryServiceSubnetResponse> forRecoveryServiceSubnet(BmcGenericWaiter waiter, GetRecoveryServiceSubnetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRecoveryServiceSubnetRequest, GetRecoveryServiceSubnetResponse>(){

            @Override
            public GetRecoveryServiceSubnetResponse apply(GetRecoveryServiceSubnetRequest request) {
                return DatabaseRecoveryWaiters.this.client.getRecoveryServiceSubnet(request);
            }
        }, (Predicate)new Predicate<GetRecoveryServiceSubnetResponse>(){

            @Override
            public boolean test(GetRecoveryServiceSubnetResponse response) {
                return targetStatesSet.contains((Object)response.getRecoveryServiceSubnet().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DatabaseRecoveryWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

