/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.recovery.DatabaseRecovery;
import com.oracle.bmc.recovery.model.ProtectedDatabaseSummary;
import com.oracle.bmc.recovery.model.ProtectionPolicySummary;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import com.oracle.bmc.recovery.model.WorkRequestError;
import com.oracle.bmc.recovery.model.WorkRequestLogEntry;
import com.oracle.bmc.recovery.model.WorkRequestSummary;
import com.oracle.bmc.recovery.requests.ListProtectedDatabasesRequest;
import com.oracle.bmc.recovery.requests.ListProtectionPoliciesRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestsRequest;
import com.oracle.bmc.recovery.responses.ListProtectedDatabasesResponse;
import com.oracle.bmc.recovery.responses.ListProtectionPoliciesResponse;
import com.oracle.bmc.recovery.responses.ListRecoveryServiceSubnetsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DatabaseRecoveryPaginators {
    private final DatabaseRecovery client;

    public DatabaseRecoveryPaginators(DatabaseRecovery client) {
        this.client = client;
    }

    public Iterable<ListProtectedDatabasesResponse> listProtectedDatabasesResponseIterator(final ListProtectedDatabasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProtectedDatabasesRequest.Builder>(){

            @Override
            public ListProtectedDatabasesRequest.Builder get() {
                return ListProtectedDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectedDatabasesResponse, String>(){

            @Override
            public String apply(ListProtectedDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectedDatabasesRequest.Builder>, ListProtectedDatabasesRequest>(){

            @Override
            public ListProtectedDatabasesRequest apply(RequestBuilderAndToken<ListProtectedDatabasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectedDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectedDatabasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectedDatabasesRequest, ListProtectedDatabasesResponse>(){

            @Override
            public ListProtectedDatabasesResponse apply(ListProtectedDatabasesRequest request) {
                return DatabaseRecoveryPaginators.this.client.listProtectedDatabases(request);
            }
        });
    }

    public Iterable<ProtectedDatabaseSummary> listProtectedDatabasesRecordIterator(final ListProtectedDatabasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProtectedDatabasesRequest.Builder>(){

            @Override
            public ListProtectedDatabasesRequest.Builder get() {
                return ListProtectedDatabasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectedDatabasesResponse, String>(){

            @Override
            public String apply(ListProtectedDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectedDatabasesRequest.Builder>, ListProtectedDatabasesRequest>(){

            @Override
            public ListProtectedDatabasesRequest apply(RequestBuilderAndToken<ListProtectedDatabasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectedDatabasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectedDatabasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectedDatabasesRequest, ListProtectedDatabasesResponse>(){

            @Override
            public ListProtectedDatabasesResponse apply(ListProtectedDatabasesRequest request) {
                return DatabaseRecoveryPaginators.this.client.listProtectedDatabases(request);
            }
        }, (Function)new Function<ListProtectedDatabasesResponse, List<ProtectedDatabaseSummary>>(){

            @Override
            public List<ProtectedDatabaseSummary> apply(ListProtectedDatabasesResponse response) {
                return response.getProtectedDatabaseCollection().getItems();
            }
        });
    }

    public Iterable<ListProtectionPoliciesResponse> listProtectionPoliciesResponseIterator(final ListProtectionPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProtectionPoliciesRequest.Builder>(){

            @Override
            public ListProtectionPoliciesRequest.Builder get() {
                return ListProtectionPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectionPoliciesResponse, String>(){

            @Override
            public String apply(ListProtectionPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectionPoliciesRequest.Builder>, ListProtectionPoliciesRequest>(){

            @Override
            public ListProtectionPoliciesRequest apply(RequestBuilderAndToken<ListProtectionPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectionPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectionPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectionPoliciesRequest, ListProtectionPoliciesResponse>(){

            @Override
            public ListProtectionPoliciesResponse apply(ListProtectionPoliciesRequest request) {
                return DatabaseRecoveryPaginators.this.client.listProtectionPolicies(request);
            }
        });
    }

    public Iterable<ProtectionPolicySummary> listProtectionPoliciesRecordIterator(final ListProtectionPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProtectionPoliciesRequest.Builder>(){

            @Override
            public ListProtectionPoliciesRequest.Builder get() {
                return ListProtectionPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectionPoliciesResponse, String>(){

            @Override
            public String apply(ListProtectionPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectionPoliciesRequest.Builder>, ListProtectionPoliciesRequest>(){

            @Override
            public ListProtectionPoliciesRequest apply(RequestBuilderAndToken<ListProtectionPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectionPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectionPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectionPoliciesRequest, ListProtectionPoliciesResponse>(){

            @Override
            public ListProtectionPoliciesResponse apply(ListProtectionPoliciesRequest request) {
                return DatabaseRecoveryPaginators.this.client.listProtectionPolicies(request);
            }
        }, (Function)new Function<ListProtectionPoliciesResponse, List<ProtectionPolicySummary>>(){

            @Override
            public List<ProtectionPolicySummary> apply(ListProtectionPoliciesResponse response) {
                return response.getProtectionPolicyCollection().getItems();
            }
        });
    }

    public Iterable<ListRecoveryServiceSubnetsResponse> listRecoveryServiceSubnetsResponseIterator(final ListRecoveryServiceSubnetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecoveryServiceSubnetsRequest.Builder>(){

            @Override
            public ListRecoveryServiceSubnetsRequest.Builder get() {
                return ListRecoveryServiceSubnetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecoveryServiceSubnetsResponse, String>(){

            @Override
            public String apply(ListRecoveryServiceSubnetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecoveryServiceSubnetsRequest.Builder>, ListRecoveryServiceSubnetsRequest>(){

            @Override
            public ListRecoveryServiceSubnetsRequest apply(RequestBuilderAndToken<ListRecoveryServiceSubnetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecoveryServiceSubnetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecoveryServiceSubnetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecoveryServiceSubnetsRequest, ListRecoveryServiceSubnetsResponse>(){

            @Override
            public ListRecoveryServiceSubnetsResponse apply(ListRecoveryServiceSubnetsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listRecoveryServiceSubnets(request);
            }
        });
    }

    public Iterable<RecoveryServiceSubnetSummary> listRecoveryServiceSubnetsRecordIterator(final ListRecoveryServiceSubnetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecoveryServiceSubnetsRequest.Builder>(){

            @Override
            public ListRecoveryServiceSubnetsRequest.Builder get() {
                return ListRecoveryServiceSubnetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecoveryServiceSubnetsResponse, String>(){

            @Override
            public String apply(ListRecoveryServiceSubnetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecoveryServiceSubnetsRequest.Builder>, ListRecoveryServiceSubnetsRequest>(){

            @Override
            public ListRecoveryServiceSubnetsRequest apply(RequestBuilderAndToken<ListRecoveryServiceSubnetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecoveryServiceSubnetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecoveryServiceSubnetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecoveryServiceSubnetsRequest, ListRecoveryServiceSubnetsResponse>(){

            @Override
            public ListRecoveryServiceSubnetsResponse apply(ListRecoveryServiceSubnetsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listRecoveryServiceSubnets(request);
            }
        }, (Function)new Function<ListRecoveryServiceSubnetsResponse, List<RecoveryServiceSubnetSummary>>(){

            @Override
            public List<RecoveryServiceSubnetSummary> apply(ListRecoveryServiceSubnetsResponse response) {
                return response.getRecoveryServiceSubnetCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DatabaseRecoveryPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

