/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RecognizedRule;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;

public class SyntaxError
extends AssertionError {
    public int line;
    public int offset;
    public int end;
    public String code;
    public String marker = "^^^";
    public String detailedMessageKey = "SyntaxError_DetailedMessage";
    private List<RecognizedRule> weightedRules;
    private Earley earley;
    public Matrix matrix;
    static String TITLE = "Syntax Error";
    static final String MESSAGE_KEY = "SyntaxError_Message";
    static final int prefixFactor = 100;
    public static final int prefixWeight = 1000;
    public static final int progressionWeight = 100;

    public static SyntaxError checkSQLQuerySyntax(String input) {
        return SyntaxError.checkSyntax(input, new String[]{"subquery", "select", "sql_statement"});
    }

    public static SyntaxError checkSQLQuerySyntax(String input, String marker, String format) {
        return SyntaxError.checkSyntax(input, new String[]{"subquery", "select", "sql_statement"}, marker, format);
    }

    public static SyntaxError checkSQLStatementSyntax(String input) {
        return SyntaxError.checkSyntax(input, new String[]{"sql_statements"});
    }

    public static SyntaxError checkSQLStatementSyntax(String input, String marker, String format) {
        return SyntaxError.checkSyntax(input, new String[]{"sql_statements"}, marker, format);
    }

    public static SyntaxError checkSingleStatement(String input) {
        return SyntaxError.checkSyntax(input, new String[]{"sql_statement", "select", "insert", "update", "delete", "merge"});
    }

    public String[] getSuggestions() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Long s : this.topNsuggestions()) {
            String candidate = this.earley.allSymbols[Service.lX(s)];
            if (ret.contains(candidate) || 0 < candidate.indexOf(91)) continue;
            ret.add(candidate);
        }
        return ret.toArray(new String[0]);
    }

    public static SyntaxError checkSyntax(String input, String[] grammarSymbols) {
        return SyntaxError.checkSyntax(input, grammarSymbols, "^^^", "SyntaxError_DetailedMessage");
    }

    private static SyntaxError checkSyntax(String input, String[] grammarSymbols, String marker, String format) {
        List<LexerToken> src = Lexer.parse(input);
        SqlEarley earley = SqlEarley.partialRecognizer();
        Matrix matrix = new Matrix(earley);
        earley.parse(src, matrix);
        return SyntaxError.checkSyntax(input, grammarSymbols, src, earley, matrix, marker, format);
    }

    public static SyntaxError checkSyntax(String input, String[] grammarSymbols, List<LexerToken> src, Earley earley, Matrix matrix) {
        return SyntaxError.checkSyntax(input, grammarSymbols, src, earley, matrix, "^^^", "SyntaxError_DetailedMessage");
    }

    public static synchronized SyntaxError checkSyntax(String input, String[] grammarSymbols, List<LexerToken> src, Earley earley, Matrix matrix, String marker, String format) {
        if (src.size() == 0) {
            return null;
        }
        Parser.EarleyCell top = matrix.get(0, src.size());
        if (top != null) {
            for (String s : grammarSymbols) {
                for (int i = 0; i < top.size(); ++i) {
                    Parser.Tuple tuple = earley.rules[top.getRule(i)];
                    String candidate = earley.allSymbols[tuple.head];
                    if (!candidate.equals(s)) continue;
                    return null;
                }
            }
        }
        int maxY = matrix.lastY();
        int end = 0;
        if (0 < maxY) {
            end = src.get((int)(maxY - 1)).end;
        }
        int line = 0;
        int beginLinePos = 0;
        int endLinePos = input.length();
        for (int i = 0; i < endLinePos; ++i) {
            if (input.charAt(i) != '\n') continue;
            if (i < end) {
                ++line;
                beginLinePos = i;
                continue;
            }
            endLinePos = i;
            break;
        }
        String code = input.substring(beginLinePos, endLinePos);
        int offset = end - beginLinePos;
        LexerToken token = null;
        boolean maybePrefix = false;
        if (maxY < src.size()) {
            token = src.get(maxY);
        } else if (maxY == src.size()) {
            token = src.get(maxY - 1);
            maybePrefix = true;
        }
        LinkedList<RecognizedRule> rules = new LinkedList<RecognizedRule>();
        SyntaxError.pendingRules(earley, matrix, maxY, null, rules);
        if (maybePrefix) {
            SyntaxError.pendingRules(earley, matrix, maxY - 1, token, rules);
        }
        for (RecognizedRule rp : rules) {
            long s = SyntaxError.parentChildSymbols(rp, earley);
            String ss = earley.allSymbols[Service.lX(s)];
            if (!SyntaxError.isTypo(ss, token)) continue;
            rules = new LinkedList();
            rules.add(rp);
            return new SyntaxError(line, offset, token.begin, code, Service.identln(offset, marker), rules, earley, matrix, format);
        }
        return new SyntaxError(line, offset, end, code, Service.identln(offset, marker), rules, earley, matrix, format);
    }

    public static List<RecognizedRule> pendingRules(Earley earley, Matrix matrix, int y) {
        LinkedList<RecognizedRule> rules = new LinkedList<RecognizedRule>();
        SyntaxError.pendingRules(earley, matrix, y, null, rules);
        return rules;
    }

    private static void pendingRules(Earley earley, Matrix matrix, int y, LexerToken token, List<RecognizedRule> rules) {
        if (y < 0) {
            return;
        }
        for (int x = 0; x <= y; ++x) {
            Parser.EarleyCell cell = matrix.get(x, y);
            if (cell == null) continue;
            for (int i = 0; i < cell.size(); ++i) {
                RecognizedRule r;
                String symbol;
                int rule = cell.getRule(i);
                int pos = cell.getPosition(i);
                Parser.Tuple t = earley.rules[rule];
                if (pos >= t.rhs.length || (symbol = earley.allSymbols[t.rhs[pos]]).startsWith("xml")) continue;
                String[] rhs = new String[t.rhs.length];
                for (int j = 0; j < rhs.length; ++j) {
                    rhs[j] = earley.allSymbols[t.rhs[j]];
                }
                if (token == null) {
                    RecognizedRule r2 = new RecognizedRule(earley.allSymbols[t.head], rhs, pos, x, y, 1);
                    if (r2.isRedundant(rules)) continue;
                    rules.add(r2);
                    continue;
                }
                if (token.type != Token.IDENTIFIER || !earley.isTerminal(earley.rules[rule].rhs[pos]) || !symbol.substring(1).toUpperCase().startsWith(token.content.toUpperCase()) || symbol.length() == token.content.length() + 2 || (r = new RecognizedRule(earley.allSymbols[t.head], rhs, pos, x, y, token.content.length() * 100)).isRedundant(rules)) continue;
                rules.add(r);
            }
        }
    }

    private static boolean isTypo(String symbol, LexerToken token) {
        if (token == null || token.begin + 1 == token.end || token.begin + 2 == token.end) {
            return false;
        }
        String candidate = "'" + token.content.toUpperCase() + "'";
        if (symbol.length() + 1 == candidate.length() || symbol.length() == candidate.length() + 1 || symbol.length() == candidate.length()) {
            int i;
            int matched = 0;
            int brokenAt = -1;
            for (i = 0; i < symbol.length() && i < candidate.length(); ++i) {
                if (symbol.charAt(i) == candidate.charAt(i)) {
                    ++matched;
                    continue;
                }
                brokenAt = i;
                break;
            }
            if (brokenAt + 1 < symbol.length() && brokenAt + 1 < candidate.length() && symbol.charAt(brokenAt + 1) == candidate.charAt(brokenAt + 1)) {
                for (i = brokenAt + 1; i < symbol.length() && i < candidate.length() && symbol.charAt(i) == candidate.charAt(i); ++i) {
                    ++matched;
                }
            } else if (brokenAt + 1 < symbol.length() && symbol.charAt(brokenAt + 1) == candidate.charAt(brokenAt)) {
                for (i = brokenAt; i + 1 < symbol.length() && i < candidate.length() && symbol.charAt(i + 1) == candidate.charAt(i); ++i) {
                    ++matched;
                }
            } else if (brokenAt + 1 < candidate.length() && symbol.charAt(brokenAt) == candidate.charAt(brokenAt + 1)) {
                for (i = brokenAt; i < symbol.length() && i + 1 < candidate.length() && symbol.charAt(i) == candidate.charAt(i + 1); ++i) {
                    ++matched;
                }
            }
            if (matched == symbol.length() - 1 || matched == candidate.length() - 1) {
                return true;
            }
        }
        return false;
    }

    private SyntaxError(int line, int offset, int end, String code, String marker, List<RecognizedRule> rules, Earley earley, Matrix matrix, String format) {
        this.line = line;
        this.offset = offset;
        this.end = end;
        this.code = code;
        this.marker = marker;
        this.earley = earley;
        this.detailedMessageKey = format;
        this.matrix = matrix;
        this.weightedRules = new LinkedList<RecognizedRule>();
        int i = -1;
        for (RecognizedRule r : rules) {
            if (!(earley instanceof SqlEarley && "'{'".equals(r.rhs[0]) || r.isRedundant(rules))) {
                this.weightedRules.add(r);
            }
            if (100 >= ++i) continue;
            break;
        }
        Collections.sort(this.weightedRules, new Comparator<RecognizedRule>(){

            @Override
            public int compare(RecognizedRule o1, RecognizedRule o2) {
                return o2.weight - o1.weight > 0L ? 1 : (o2.weight - o1.weight < 0L ? -1 : 0);
            }
        });
    }

    public String toString() {
        return this.getDetailedMessage();
    }

    public String getDetailedMessage() {
        String pointer = Service.padln(this.marker, this.code.length());
        StringBuilder allSuggestions = new StringBuilder();
        LinkedList<String> ret = new LinkedList<String>();
        for (long s : this.topNsuggestions()) {
            String candidate = this.earley.allSymbols[Service.lX(s)];
            if (ret.contains(candidate) || 0 < candidate.indexOf(91)) continue;
            ret.add(candidate);
            allSuggestions.append(candidate + ",");
        }
        String suggestions = allSuggestions.toString();
        if (60 < suggestions.length()) {
            suggestions = suggestions.substring(0, 50);
        }
        return "Syntax Error at line " + (this.line + 1) + ", column " + this.offset + "\n\n" + this.code + "\n" + pointer + "\nExpected: " + suggestions + "\n";
    }

    public String getMessage() {
        return this.getDetailedMessage();
    }

    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - void declaration
     */
    public List<Long> topNsuggestions() {
        TreeMap<Long, Integer> topN = new TreeMap<Long, Integer>();
        int N = 10;
        for (RecognizedRule recognizedRule : this.weightedRules) {
            long l = -1L;
            int minVal = Integer.MAX_VALUE;
            Iterator iterator = topN.keySet().iterator();
            while (iterator.hasNext()) {
                long s = (Long)iterator.next();
                int tmp = (Integer)topN.get(s);
                if (tmp >= minVal) continue;
                l = s;
                minVal = tmp;
            }
            long suggestedVar = SyntaxError.parentChildSymbols(recognizedRule, this.earley);
            String candidate = this.earley.allSymbols[Service.lX(suggestedVar)];
            if (0 < candidate.indexOf("___") || 0 == candidate.indexOf("\"") || this.hasParent(topN, this.earley.allSymbols[Service.lY(suggestedVar)])) continue;
            Integer suggestedVal = HarvestDoc.getFrequencies().get(suggestedVar);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            if (topN.size() == 10) {
                if (suggestedVal == null || minVal >= suggestedVal) continue;
                topN.remove(l);
                topN.put(suggestedVar, suggestedVal);
                continue;
            }
            topN.put(suggestedVar, suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry entry : topN.entrySet()) {
            myList.add(entry);
        }
        Collections.sort(myList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        LinkedList<Long> linkedList = new LinkedList<Long>();
        boolean bl = false;
        for (Map.Entry e : myList) {
            void var5_11;
            if (10 < var5_11) break;
            linkedList.add((Long)e.getKey());
            ++var5_11;
        }
        return linkedList;
    }

    boolean hasParent(Map<Long, Integer> topN, String cmp) {
        for (Long l : topN.keySet()) {
            if (!cmp.equals(this.earley.allSymbols[Service.lY(l)])) continue;
            return true;
        }
        return false;
    }

    public List<RecognizedRule> topNrules(int N, boolean excludeAux) {
        return this.topNrules(N, excludeAux, null);
    }

    public List<RecognizedRule> topNrules(int N, boolean excludeAux, String prefix) {
        LinkedList<RecognizedRule> ret = new LinkedList<RecognizedRule>();
        for (RecognizedRule rp : this.weightedRules) {
            String current;
            if (excludeAux && 0 < rp.head.indexOf(91)) continue;
            if (prefix != null && (current = rp.rhs[rp.pos].toLowerCase()).startsWith("'" + prefix.toLowerCase())) {
                rp.weight *= (long)(1000 * prefix.length());
                ret.add(rp);
                continue;
            }
            ret.add(rp);
        }
        Collections.sort(ret, new Comparator<RecognizedRule>(){

            @Override
            public int compare(RecognizedRule o1, RecognizedRule o2) {
                return o2.weight - o1.weight > 0L ? 1 : (o2.weight - o1.weight < 0L ? -1 : 0);
            }
        });
        if (ret.size() <= N) {
            return ret;
        }
        return ret.subList(0, N);
    }

    private static long parentChildSymbols(RecognizedRule rp, Earley earley) {
        long entry = Service.lPair((Integer)earley.symbolIndexes.get(rp.rhs[rp.pos]), (Integer)earley.symbolIndexes.get(rp.head));
        return entry;
    }

    public static void main(String[] args) throws Exception {
        String input = "--dbtools-dev[system]\nSELECT * FROM HR.EMPLOY";
        SyntaxError ret = SyntaxError.checkSQLStatementSyntax(input);
        System.out.println(ret.getDetailedMessage());
        System.out.println("-----------------------------");
        for (RecognizedRule rr : ret.topNrules(3, true)) {
            System.out.println(rr.toString());
        }
    }
}

