/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import oracle.arbori.util.CharOffsets;
import oracle.arbori.util.DbObjNames;
import oracle.arbori.util.IO;

public class Service
extends IO {
    public static void main(String[] args) throws Exception {
        int c;
        int c1;
        int i;
        String text = "select \n from \n dual";
        System.out.println(text);
        int[] map = Service.lineMap(text);
        for (i = 1; i < map.length + 2; ++i) {
            int c2 = Service.lineNo2CharPos(text, i);
            int c12 = Service.lineNo2CharPos1(map, i);
            if (c12 == c2) continue;
            System.out.println("lineNo2CharPos1[" + i + "]=" + c12 + ", lineNo2CharPos[" + i + "]=" + c2);
        }
        for (i = 0; i < text.length() + 1; ++i) {
            c1 = Service.charPos2LineNo1(map, i);
            if (c1 == (c = Service.charPos2LineNo(text, i))) continue;
            System.out.println("charPos2LineNo1[" + i + "]=" + c1 + ", charPos2LineNo[" + i + "]=" + c);
        }
        text = "select \n\r from \n\r dual";
        map = Service.lineMap(text);
        System.out.println(text);
        for (i = 1; i < map.length + 2; ++i) {
            c1 = Service.lineNo2CharPos1(map, i);
            if (c1 == (c = Service.lineNo2CharPos(text, i))) continue;
            System.out.println("lineNo2CharPos1[" + i + "]=" + c1 + ", lineNo2CharPos[" + i + "]=" + c);
        }
        for (i = 0; i < text.length() + 1; ++i) {
            c1 = Service.charPos2LineNo1(map, i);
            if (c1 == (c = Service.charPos2LineNo(text, i))) continue;
            System.out.println("charPos2LineNo1[" + i + "]=" + c1 + ", charPos2LineNo[" + i + "]=" + c);
        }
    }

    public static String cleanFileName(String fileName) {
        return Service.cleanFileName(fileName, "@");
    }

    public static String cleanFileName(String fileName, String replace) {
        String clean = fileName.replaceAll("[<>:/\\|?*]", replace);
        return clean;
    }

    public static String cleanScriptFileName(String fileName) {
        return Service.cleanScriptFileName(fileName, "_", "_");
    }

    public static String cleanScriptFileName(String fileName, String replace, String replaceSpace) {
        String clean = fileName.replaceAll("[<>:/\\|?*()%&'$@^~/#]", replace);
        clean = clean.replaceAll(" ", replaceSpace);
        return clean;
    }

    public static String convertNonAsciiFileName(String fileName) {
        if (!Service.isAscii(fileName)) {
            return Integer.valueOf(fileName.hashCode()).toString();
        }
        return fileName;
    }

    public static boolean isAscii(String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c <= 'z') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(URL url, String dstdir) {
        InputStream in = null;
        OutputStream out = null;
        ZipFile jar = null;
        try {
            int len;
            String name;
            if (url.toString().startsWith("jar:file:")) {
                int end = url.toString().indexOf(33);
                String jarFile = url.toString().substring("jar:file:".length(), end);
                jar = new JarFile(jarFile);
                JarEntry je = ((JarFile)jar).getJarEntry(url.toString().substring(end + 2));
                in = ((JarFile)jar).getInputStream(je);
                String path = je.getName();
                File file = new File(path);
                name = file.getName();
            } else {
                String path = url.getPath();
                File file = new File(path);
                name = file.getName();
                in = new FileInputStream(path);
            }
            out = new FileOutputStream(new File(dstdir + File.separator + name));
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String fromPath, String fromEncoding, String toPath, String toEncoding) {
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            FileInputStream fin = new FileInputStream(fromPath);
            BufferedInputStream bin = new BufferedInputStream(fin);
            reader = fromEncoding == null ? new InputStreamReader(bin) : new InputStreamReader((InputStream)bin, fromEncoding);
            File toFile = new File(toPath);
            File toDir = toFile.getParentFile();
            if (!toDir.isDirectory()) {
                toDir.mkdirs();
            }
            if (!toFile.isFile()) {
                toFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(toPath);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            writer = toEncoding == null ? new OutputStreamWriter(bout) : new OutputStreamWriter((OutputStream)bout, toEncoding);
            int len = 0;
            char[] buf = new char[1024];
            while ((len = reader.read(buf, 0, 1024)) > 0) {
                writer.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            try {
                writer.close();
            }
            catch (Exception e) {
                Logger.getLogger(Service.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public static String toNull(String src) {
        return "".equals(src) ? null : src;
    }

    public static String identln(int level, String txt) {
        return Service.identln(level, txt, " ");
    }

    public static String identln(int level, String txt, String filling) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            b.append(filling);
        }
        b.append(txt);
        return b.toString();
    }

    public static int charPos2LineNo(String txt, int pos) {
        return CharOffsets.charPos2LineNo(txt, pos);
    }

    public static int lineNo2CharPos(String txt, int line) {
        return CharOffsets.lineNo2CharPos(txt, line);
    }

    public static int[] lineMap(String txt) {
        return CharOffsets.lineMap(txt);
    }

    public static int lineNo2CharPos0(int[] lineMap, int line) {
        return CharOffsets.lineNo2CharPos0(lineMap, line);
    }

    public static int lineNo2CharPos1(int[] lineMap, int line) {
        return Service.lineNo2CharPos0(lineMap, line - 1);
    }

    public static int charPos2LineNo0(int[] lineMap, int pos) {
        return CharOffsets.charPos2LineNo0(lineMap, pos);
    }

    public static int charPos2LineNo1(int[] lineMap, int pos) {
        return Service.charPos2LineNo0(lineMap, pos) + 1;
    }

    public static String padln(String txt, int newsize) {
        StringBuffer b = new StringBuffer(txt);
        for (int i = txt.length(); i < newsize; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    public static int pair(int x, int y) {
        return y << 16 | x;
    }

    public static int Y(int p) {
        return p >> 16;
    }

    public static int X(int p) {
        return p & 0xFFFF;
    }

    public static String replace(String input, String target, String replacement) {
        return input.replace(target, replacement);
    }

    public static long lPair(int x, int y) {
        return (long)y << 32 | (long)x;
    }

    public static int lY(long pair) {
        return (int)(pair >> 32);
    }

    public static int lX(long pair) {
        return (int)pair;
    }

    public static int decrPair(int p) {
        return p - 65537;
    }

    public static long addlX(long pair, int x) {
        return pair + (long)x;
    }

    public static long addlY(long pair, int y) {
        return pair + ((long)y << 32);
    }

    public static String handleMixedCase(String name) {
        return Service.handleMixedCase(name, true);
    }

    public static String handleMixedCase(String name, boolean unquote) {
        return DbObjNames.handleMixedCase(name, unquote);
    }

    public static String addDoubleQuote(String s) {
        return Service.quoteIdentifier(s, '\"');
    }

    public static String quoteIdentifier(String s, char quoteChar) {
        return DbObjNames.quoteIdentifier(s, quoteChar);
    }

    public static String shortenIdentifier(String id, List<String> uniqueIds, int idSize) {
        return DbObjNames.shortenIdentifier(id, uniqueIds, idSize);
    }

    public static String into2chars(String data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length(); ++i) {
            ret.append(Service.into2chars(data.charAt(i)));
        }
        return ret.toString();
    }

    public static String from2chars(String data) {
        if (data == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            char[] chunk = new char[2];
            chunk[0] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[1] = data.charAt(i++);
            ret.append(Service.from2chars(chunk));
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    static char[] into2chars(char input) {
        char[] ret = new char[]{(char)(Service.periodicRemainder(input, 16) + 70), (char)(Service.periodicDivision(input, 16) + 70)};
        return ret;
    }

    static char from2chars(char[] input) {
        return (char)((input[1] - 70) * 16 + (input[0] - 70));
    }

    static int periodicRemainder(int i, int j) {
        int ret = i % j;
        if (ret < 0) {
            ret += j;
        }
        return ret;
    }

    static int periodicDivision(int i, int j) {
        int ret = i / j;
        if (ret < 0) {
            --ret;
        }
        return ret;
    }

    public static String into4chars(String data) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length(); ++i) {
            ret.append(Service.into4chars(data.charAt(i)));
        }
        return ret.toString();
    }

    public static String from4chars(String data) {
        if (data == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            char[] chunk = new char[4];
            chunk[0] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[1] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[2] = data.charAt(i++);
            if (i >= data.length()) {
                return null;
            }
            chunk[3] = data.charAt(i++);
            ret.append(Service.from4chars(chunk));
        }
        if (ret.length() == 0) {
            return null;
        }
        return ret.toString();
    }

    static char[] into4chars(char input) {
        char[] ret = new char[4];
        int mod = Service.periodicRemainder(input, 4096);
        int div = Service.periodicDivision(input, 4096);
        ret[3] = (char)(div + 70);
        div = Service.periodicDivision(mod, 256);
        mod = Service.periodicRemainder(mod, 256);
        ret[2] = (char)(div + 70);
        ret[0] = (char)(Service.periodicRemainder(mod, 16) + 70);
        ret[1] = (char)(Service.periodicDivision(mod, 16) + 70);
        return ret;
    }

    static char from4chars(char[] input) {
        return (char)((input[3] - 70) * 16 * 16 * 16 + (input[2] - 70) * 16 * 16 + (input[1] - 70) * 16 + (input[0] - 70));
    }

    public static int[] toArray(Set<Integer> s) {
        int[] ret = new int[s.size()];
        int i = 0;
        for (int ii : s) {
            ret[i++] = ii;
        }
        return ret;
    }

    public static enum CLEAN_TYPE {
        OFF,
        TRANSFORM30,
        TRANSFORM128,
        QUOTE30,
        QUOTE128,
        UNIQUE;

    }
}

