/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.zip;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.core.io.InputOutputStreams;

public class ZipArchive {
    private final byte[] bytes;
    private static final InputOutputStreams STREAMS = InputOutputStreams.instance();

    private ZipArchive(InputStream contents) throws IOException {
        this.bytes = STREAMS.asByteArray(contents);
    }

    public byte[] bytes() {
        try {
            return STREAMS.asByteArray(this.toInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public InputStream toInputStream() {
        return STREAMS.asInputStream(this.bytes);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int maxNameLength = 32;
        try (ZipInputStream zip = new ZipInputStream(this.toInputStream());){
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                String line = String.format("%1$-32s %2$10s %3$-20s", entry.getName(), ZipArchive.readableFileSize(entry.getSize()), entry.getLastModifiedTime().toInstant().toString());
                b.append(line);
                b.append('\n');
                STREAMS.copy(zip, STREAMS.nullOutputStream());
                entry = zip.getNextEntry();
            }
        }
        catch (IOException e) {
            b.append(e.getMessage());
        }
        return b.toString();
    }

    public ZipInputStream toZipInputStream() {
        return new ZipInputStream(this.toInputStream());
    }

    public static ZipArchive from(InputStream contents) throws IOException {
        return new ZipArchive(contents);
    }

    private static String readableFileSize(long size) {
        if (size < 0L) {
            return "-";
        }
        if (size == 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }
}

