/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.secrets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import oracle.dbtools.core.secrets.BinarySecret;
import oracle.dbtools.core.secrets.BinarySecretImpl;
import oracle.dbtools.core.secrets.KeyAlgorithm;
import oracle.dbtools.core.secrets.SecretException;
import oracle.dbtools.core.secrets.TextSecret;

public class Secrets {
    private static final KeyAlgorithm ENCRYPTION_ALGORITHM = KeyAlgorithm.AES_GCM;
    private static final Secrets INSTANCE = new Secrets();
    private final SecureRandom initializationVector;
    private final Key masterKey = ENCRYPTION_ALGORITHM.generate(new SecureRandom()::nextBytes);

    private Secrets() {
        this.initializationVector = new SecureRandom();
    }

    public static Secrets instance() {
        return INSTANCE;
    }

    private byte[] decrypt(byte[] cipherText) {
        try {
            KeyAlgorithm algo = ENCRYPTION_ALGORITHM;
            Cipher cipher = algo.cipher();
            int ivSize = cipher.getBlockSize();
            byte[] iv = Arrays.copyOfRange(cipherText, 0, ivSize);
            AlgorithmParameterSpec parameterSpec = algo.parameterSpec(iv);
            cipher.init(2, this.masterKey, parameterSpec);
            byte[] plaintext = cipher.doFinal(cipherText, ivSize, cipherText.length - ivSize);
            return plaintext;
        }
        catch (GeneralSecurityException e) {
            throw SecretException.of(e);
        }
    }

    private byte[] encrypt(byte[] plainText) {
        try {
            KeyAlgorithm algo = ENCRYPTION_ALGORITHM;
            Cipher cipher = algo.cipher();
            int ivSize = cipher.getBlockSize();
            ByteArrayOutputStream ciphertext = new ByteArrayOutputStream();
            byte[] iv = new byte[ivSize];
            this.initializationVector.nextBytes(iv);
            AlgorithmParameterSpec parameterSpec = algo.parameterSpec(iv);
            cipher.init(1, this.masterKey, parameterSpec);
            ciphertext.write(iv);
            ciphertext.write(cipher.doFinal(plainText));
            return ciphertext.toByteArray();
        }
        catch (IOException | GeneralSecurityException e) {
            throw SecretException.of(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextSecret of(char[] secret, boolean erase) {
        if (secret == null) {
            return TextSecret.none();
        }
        byte[] utf8 = this.utf8(secret);
        try {
            TextSecret s = this.of(utf8, false).asText();
            if (erase) {
                TextSecret.erase(secret);
            }
            TextSecret textSecret = s;
            return textSecret;
        }
        finally {
            BinarySecret.erase(utf8);
        }
    }

    public BinarySecret of(byte[] secret, boolean erase) {
        if (secret == null) {
            return BinarySecret.none();
        }
        int hashCode = Arrays.hashCode(secret);
        byte[] obfuscated = this.encrypt(secret);
        BinarySecretImpl s = new BinarySecretImpl(hashCode, obfuscated, this::decrypt);
        if (erase) {
            BinarySecret.erase(secret);
        }
        return s;
    }

    private byte[] utf8(char[] text) {
        CharBuffer chars = CharBuffer.wrap(text);
        ByteBuffer utf8 = StandardCharsets.UTF_8.encode(chars);
        return Arrays.copyOf(utf8.array(), utf8.limit());
    }
}

