/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.util;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.helpers.ConnectCredentials;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.storage.StoreException;
import oracle.dbtools.core.connections.storage.UnicodeSafeWalletSecrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public final class ConnectionsSupport {
    private final ConnectionStorage storage;
    private final Properties productProperties = new Properties();

    public static Builder builder(ConnectionStorage store) {
        return new Builder(store);
    }

    public static Builder builder() {
        return new Builder(ConnectionStorage.instance());
    }

    public static ConnectionsSupport of(ConnectionStorage store) {
        return ConnectionsSupport.builder(store).build();
    }

    public static ConnectionsSupport ofDefaultStore() {
        return ConnectionsSupport.builder().build();
    }

    private ConnectionsSupport(Builder builder) {
        this.storage = builder.store;
        this.productProperties.putAll((Map<?, ?>)builder.props);
    }

    public ConnectionStorage getStorage() {
        return this.storage;
    }

    public Connection openConnection(String name) throws IllegalStateException, SQLException {
        return this.openConnection(name, null);
    }

    public Connection openConnection(String name, String username, TextSecret password, String role) throws IllegalStateException, SQLException {
        return this.openConnection(name, ConnectCredentials.of(username, password, role));
    }

    private Connection openConnection(String name, ConnectCredentials credentials) throws IllegalStateException, SQLException {
        ConnectionDefinition connectionDefinition = this.lookupConnection(name);
        if (connectionDefinition == null) {
            throw new IllegalStateException("Connection not found: " + name);
        }
        ConnectionHelper helper = ConnectionHelperFactory.findHelper(ConnectionHelperContext.builder(connectionDefinition).build());
        return helper.createConnection(credentials, this.productProperties);
    }

    public ConnectionDefinition lookupConnection(String name) throws IllegalStateException {
        Optional<ConnectionDefinition> opt = this.storage.listConnectionDirectories().stream().map(this.storage::loadConnection).filter(def -> Objects.equals(def.getConnectionName(), name)).findFirst();
        return opt.orElse(null);
    }

    public ConnectionDefinition createOracleConnectionDefinition(String name, String connectString, String userName, TextSecret password) throws IllegalStateException {
        ConfigurationProperties.Builder configurationPropertiesBuilder = ConfigurationProperties.builder();
        configurationPropertiesBuilder.set("name", name).set("type", "ORACLE_DATABASE").set("connectionString", connectString).set("userName", userName);
        ConnectionDefinition.Builder defBuilder = ConnectionDefinition.builder(ConnectionIdentifiers.createUniqueIdentifier());
        defBuilder.dbtoolsProperties(configurationPropertiesBuilder.build());
        try {
            if (password.isPresent()) {
                OracleWallet wallet = new OracleWallet();
                wallet.createSSO();
                OracleSecretStore store = wallet.getSecretStore();
                UnicodeSafeWalletSecrets secrets = UnicodeSafeWalletSecrets.of(store);
                secrets.write((CharSequence)"dbtools.database.password.base64", password);
                wallet.setSecretStore(store);
                defBuilder.wallet(wallet);
            }
        }
        catch (IOException | OracleSecretStoreException exception) {
            throw new IllegalStateException(exception);
        }
        return defBuilder.build();
    }

    public void storeConnection(ConnectionDefinition definition) throws IllegalStateException {
        try {
            this.storage.storeDefinition(definition);
        }
        catch (StoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class Builder {
        private final ConnectionStorage store;
        private final Properties props = new Properties();

        private Builder(ConnectionStorage store) {
            this.store = store;
        }

        public Builder productProperty(String key, String value) {
            this.props.setProperty(key, value);
            return this;
        }

        public ConnectionsSupport build() {
            return new ConnectionsSupport(this);
        }
    }
}

