/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.helpers;

import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.MessageLogger;

public abstract class BaseConnectionHelper
implements ConnectionHelper {
    protected final ConnectionDefinition definition;
    protected final MessageLogger logger;

    protected static boolean hasLength(CharSequence cs) {
        return cs != null && cs.length() > 0;
    }

    protected BaseConnectionHelper(ConnectionHelperContext ctx) {
        this.definition = ctx.getDefinition();
        this.logger = ctx.getLogger();
    }

    protected boolean isSet(String s) {
        return s != null && !s.isEmpty();
    }

    protected boolean isSet(TextSecret secret) {
        return secret != null && secret.isPresent();
    }

    protected static ConnectionHelper.DisplayEntry createDisplayEntry(String key, String value) {
        return BaseConnectionHelper.createDisplayEntry(key, value, false);
    }

    protected static ConnectionHelper.DisplayEntry createDisplayEntry(String key, String value, boolean useNewLine) {
        return ConnectionHelper.displayEntry(key, value != null ? value : "", useNewLine);
    }

    public static String getUsername(ConnectionDefinition definition) {
        return definition.getDbtoolsProperties().getProperty("userName");
    }

    public static String getDbtoolsProperty(ConnectionDefinition definition, String key) {
        return definition.getDbtoolsProperties().getProperty(key);
    }
}

