/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.collections;

import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.Slice;

public interface Buffer<E>
extends Slice<E> {
    public static <E> Buffer<E> buffer() {
        return Slice.builder();
    }

    public static <E> Collector<E, Buffer<E>, Buffer<E>> toBuffer() {
        return new Collector<E, Buffer<E>, Buffer<E>>(){

            @Override
            public Supplier<Buffer<E>> supplier() {
                return Buffer::buffer;
            }

            @Override
            public BiConsumer<Buffer<E>, E> accumulator() {
                return Buffer::add;
            }

            @Override
            public BinaryOperator<Buffer<E>> combiner() {
                return Buffer::add;
            }

            @Override
            public Function<Buffer<E>, Buffer<E>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of(Collector.Characteristics.IDENTITY_FINISH);
            }
        };
    }

    public static <E> Buffer<E> of(Iterable<? extends E> elements) {
        return Buffer.buffer().add(elements);
    }

    @Override
    default public Spliterator<E> spliterator() {
        return new Slice.Base.SliceSpliterator(this.slice());
    }

    public Buffer<E> add(E var1);

    default public Buffer<E> add(Iterable<? extends E> elements) {
        elements.forEach(this::add);
        return this;
    }

    default public Buffer<E> add(Stream<? extends E> elements) {
        elements.forEach(this::add);
        return this;
    }

    @Override
    public E get(int var1) throws IndexOutOfBoundsException;

    public Buffer<E> clear();

    @Override
    default public Slice.Immutable<E> slice() {
        return Slice.Base.of(this.size(), this::get);
    }
}

