/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http.rest;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;

public interface ISimpleRestObjectClient {
    public void connect(ConnectionInfo var1) throws IOException;

    public void close();

    public <T> T get(String var1, T var2) throws IOException;

    public <T> T post(String var1, T var2) throws IOException;

    public <T> T put(String var1, T var2) throws IOException;

    public boolean delete(String var1) throws IOException;

    public static class ConnectionInfo {
        private final String m_name;
        private final URI m_root;
        private final String m_user;
        private final char[] m_pwd;
        private final URI m_serviceRoot;
        private final String m_clientId;
        private final String m_clientSecret;

        public ConnectionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd) {
            this(name, root, serviceRoot, username, pwd, null, null);
        }

        public ConnectionInfo(String name, URI root, URI serviceRoot, String username, char[] pwd, String clientId, String clientSecret) {
            this.m_name = name;
            this.m_root = root;
            this.m_serviceRoot = serviceRoot;
            this.m_user = username;
            this.m_pwd = pwd;
            this.m_clientId = clientId;
            this.m_clientSecret = clientSecret;
        }

        public String getName() {
            return this.m_name;
        }

        public URI getServerRoot() {
            return this.m_root;
        }

        public URI getServiceRoot() {
            return this.m_serviceRoot;
        }

        public String getUsername() {
            return this.m_user;
        }

        public char[] getPassword() {
            return this.m_pwd;
        }

        public String getClientID() {
            return this.m_clientId;
        }

        public String getClientSecret() {
            return this.m_clientSecret;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof ConnectionInfo && Objects.equals(this.m_name, ((ConnectionInfo)obj).m_name) && Objects.equals(this.m_root, ((ConnectionInfo)obj).m_root) && Objects.equals(this.m_serviceRoot, ((ConnectionInfo)obj).m_serviceRoot) && Objects.equals(this.m_user, ((ConnectionInfo)obj).m_user) && Arrays.equals(this.m_pwd, ((ConnectionInfo)obj).m_pwd);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "";
        }
    }
}

