/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.net.URI;
import java.util.Base64;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.http.auth.AuthenticationFailedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.util.CharArrayBuffer;

public abstract class SessionType {
    private static final String AUTH_PATH = "oauth2/token";

    public abstract String getType();

    protected abstract String getClientID();

    protected abstract String getClientSecret();

    public URI getAuthenticationURI(SessionInfo info) {
        URI root = info.getServerRoot();
        return root.resolve(this.getDefaultAuthenticationPath());
    }

    protected final String getDefaultAuthenticationPath() {
        return AUTH_PATH;
    }

    public final void signRequest(HttpRequest request) throws AuthenticationFailedException {
        BufferedHeader header;
        try {
            StringBuilder tmp = new StringBuilder();
            tmp.append(this.getClientID());
            tmp.append(":");
            tmp.append(this.getClientSecret());
            Base64.Encoder base64codec = Base64.getEncoder();
            byte[] base64password = base64codec.encode(tmp.toString().getBytes());
            CharArrayBuffer buffer = new CharArrayBuffer(32);
            buffer.append("Authorization: Basic ");
            buffer.append(base64password, 0, base64password.length);
            header = new BufferedHeader(buffer);
        }
        catch (ParseException e) {
            throw new AuthenticationFailedException(e);
        }
        request.addHeader((Header)header);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.getType();
    }

    public boolean canSavePasswords() {
        return false;
    }
}

