/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;

public class RunSqlCLTool
implements McpTool {
    private final String toolName = "run-sqlcl";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("run-sqlcl", "This tool executes SQLcl commands in the SQLcl CLI. If the given command requires a database connection, it prompts the user to connect using the connect tool.\nYou should:\n\n\tExecute the provided SQLcl command.\n\n\tReturn the results.\n\nArgs:\n\n\tsql: The SQLcl command to execute.\n\nReturns:\n\n\tCommand results.\n\n\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.\n", "{\n  \"type\" : \"object\",\n  \"id\" : \"urn:jsonschema:Operation\",\n  \"properties\" : {\n    \"sqlcl\" : {\n      \"type\" : \"string\",\n      \"description\": \"The SQLcl command to execute\"\n    },\n    \"mcp_client\" : {\n      \"type\" : \"string\",\n      \"description\": \"Specify the name and version of the MCP client implementation being used (e.g. Copilot, Claude, Cline...)\",\n      \"default\": \"UNKNOWN-MCP-CLIENT\"\n    },\n    \"model\" : {\n      \"type\" : \"string\",\n      \"description\": \"The name (and version) of the language model being used by the MCP client to process requests (e.g. gpt-4.1, claude-sonnet-4, llama4...\",\n      \"default\": \"UNKNOWN-LLM\"\n    }\n      },\n      \"required\": [\"sqlcl\"]\n}\n"), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents = new ArrayList<McpSchema.TextContent>();
            try {
                String sql = McpUtils.requiredArgument(arguments, "sqlcl");
                String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                String mcp_client = McpUtils.optionalArgument(arguments, "mcp_client", McpUtils.MCP_CLIENT_DEFAULT_VALUE);
                SqlClCommandsRunner sqlcl = SqlClCommandsRunner.builder().connection(ctx.getCurrentConnection()).build();
                if (!ctx.getCurrentConnection().isClosed()) {
                    try {
                        this.createMcpLogTable(ctx.getCurrentConnection());
                    }
                    catch (AuditTableException e) {
                        contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                    }
                    QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "run-sqlcl", model);
                    QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                    QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "run-sqlcl", sql);
                }
                contents.add(new McpSchema.TextContent(sqlcl.run("SET SQLFORMAT CSV\n" + sql)));
            }
            catch (SQLException | ArgumentException e) {
                return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

