/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class DisconnectTool
implements McpTool {
    private final String toolName = "disconnect";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("disconnect", "This tool performs a disconnection from the current session in an Oracle database. If a user is connected, it logs out cleanly and returns to the SQL prompt without an active database connection.\n\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.\n", "{\n  \"type\" : \"object\",\n  \"id\" : \"urn:jsonschema:Operation\",\n  \"properties\" : {\n    \"mcp_client\" : {\n      \"type\" : \"string\",\n      \"description\": \"Specify the name and version of the MCP client implementation being used (e.g. Copilot, Claude, Cline...)\",\n      \"default\": \"UNKNOWN-MCP-CLIENT\"\n    },\n    \"model\" : {\n      \"type\" : \"string\",\n      \"description\": \"The name (and version) of the language model being used by the MCP client to process requests (e.g. gpt-4.1, claude-sonnet-4, llama4...\",\n      \"default\": \"UNKNOWN-LLM\"\n    }\n  }\n}\n"), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents;
            block7: {
                contents = new ArrayList<McpSchema.TextContent>();
                try {
                    String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                    String mcp_client = McpUtils.optionalArgument(arguments, "mcp_client", McpUtils.MCP_CLIENT_DEFAULT_VALUE);
                    if (model.isEmpty()) {
                        throw new ArgumentException("Model name argument is required");
                    }
                    if (mcp_client.isEmpty()) {
                        throw new ArgumentException("MCP Client name argument is required");
                    }
                    if (ctx.getCurrentConnection() != null && !ctx.getCurrentConnection().isClosed()) {
                        try {
                            this.createMcpLogTable(ctx.getCurrentConnection());
                        }
                        catch (AuditTableException e) {
                            contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                        }
                        QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "disconnect", model);
                        QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                        QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "disconnect", "Disconnect from " + ctx.getCurrentConnection().getSchema());
                        ctx.getCurrentConnection().close();
                        ctx.setCurrentConnection(null);
                        contents.add(new McpSchema.TextContent("Successfully disconnected from database"));
                        break block7;
                    }
                    contents.add(new McpSchema.TextContent("No active database connection found"));
                }
                catch (SQLException | ArgumentException e) {
                    return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
                }
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

