/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mcp.tools;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.core.connections.util.ConnectionsSupport;
import oracle.dbtools.extension.mcp.exceptions.ArgumentException;
import oracle.dbtools.extension.mcp.exceptions.AuditTableException;
import oracle.dbtools.extension.mcp.server.McpServer;
import oracle.dbtools.extension.mcp.tools.McpTool;
import oracle.dbtools.extension.mcp.utils.McpUtils;
import oracle.dbtools.extension.mcp.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ConnectTool
implements McpTool {
    private final String toolName = "connect";

    @Override
    public McpServerFeatures.SyncToolSpecification create(ScriptRunnerContext ctx) {
        return new McpServerFeatures.SyncToolSpecification(new McpSchema.Tool("connect", "Provides an interface to connect to a specified database. If a database connection is already active, prompt the user for confirmation before switching to the new connection. If no connection exists, list the available schemas for selection.\nthe connection name is case sensitive\nNote: If the provided connection is invalid or does not match any saved connection, display instructions to the user on how to create a named connection in SQLcl\n\n\nThe `model` argument should specify only the name and version of the LLM (Large Language Model) you are using, with no additional information.\nThe `mcp_client` argument should specify only the name of the MCP (Model Context Protocol) client you are using, with no additional information.\n", "{\n  \"type\" : \"object\",\n  \"id\" : \"urn:jsonschema:Operation\",\n  \"properties\" : {\n    \"connection_name\" : {\n      \"type\" : \"string\",\n      \"description\": \"The name of the saved connection you want to connect to\"\n    },\n    \"mcp_client\" : {\n      \"type\" : \"string\",\n      \"description\": \"Specify the name and version of the MCP client implementation being used (e.g. Copilot, Claude, Cline...)\",\n      \"default\": \"UNKNOWN-MCP-CLIENT\"\n    },\n    \"model\" : {\n      \"type\" : \"string\",\n      \"description\": \"The name (and version) of the language model being used by the MCP client to process requests (e.g. gpt-4.1, claude-sonnet-4, llama4...\",\n      \"default\": \"UNKNOWN-LLM\"\n    }\n  },\n  \"required\": [\"connection_name\"]\n}\n"), (exchange, arguments) -> {
            ArrayList<McpSchema.TextContent> contents;
            block5: {
                contents = new ArrayList<McpSchema.TextContent>();
                try {
                    String connection = McpUtils.requiredArgument(arguments, "connection_name");
                    String model = McpUtils.optionalArgument(arguments, "model", McpUtils.MODEL_DEFAULT_VALUE);
                    String mcp_client = McpUtils.optionalArgument(arguments, "mcp_client", McpUtils.MCP_CLIENT_DEFAULT_VALUE);
                    ConnectionsSupport support = ConnectionsSupport.builder().productProperty("v$session.program", McpServer.productName).build();
                    ctx.setCurrentConnection(support.openConnection(connection));
                    if (ctx.getCurrentConnection() != null) {
                        try {
                            this.createMcpLogTable(ctx.getCurrentConnection());
                        }
                        catch (AuditTableException e) {
                            contents.add(new McpSchema.TextContent(e.getLocalizedMessage()));
                        }
                        QueryUtils.insertSessionInfo(ctx.getCurrentConnection(), "connect", model);
                        QueryUtils.insertClientInfo(ctx.getCurrentConnection(), mcp_client);
                        QueryUtils.insertIntoDbtoolsMcpLog(ctx.getCurrentConnection(), mcp_client, model, "tool", "connect", "Connect to " + ctx.getCurrentConnection().getSchema());
                        contents.add(new McpSchema.TextContent("### DATABASE CONNECTION ESTABLISHED ###\nSuccessfully connected to: **" + String.valueOf(arguments.get("connection_name")) + "**"));
                        contents.add(new McpSchema.TextContent("\n### DATABASE ENVIRONMENT CONTEXT ###\n"));
                        Version oracleVersion = new Version(QueryUtils.getOracleVersion(ctx.getCurrentConnection()));
                        contents.add(new McpSchema.TextContent("**1. Oracle Database Version:** \n" + String.valueOf(oracleVersion)));
                        contents.add(new McpSchema.TextContent("**2. Access Mode:** \nThe Oracle database is currently in '" + QueryUtils.getOpenMode(ctx.getCurrentConnection()) + "' mode"));
                        contents.add(new McpSchema.TextContent("**3. NLS Parameters:** \nThe current Oracle database uses the following NLS configuration:\nDatabase character set:" + QueryUtils.getCharacterSet(ctx.getCurrentConnection()) + "\n Full NLS parameters: \n" + QueryUtils.getNlsParams(ctx.getCurrentConnection()) + "\n This is important for correctly interpreting data formats, encodings, and locale-specific behavior.\n"));
                        contents.add(new McpSchema.TextContent("Here\u2019s the Oracle database context you need: version, open mode, and NLS parameters. Use this information to run the following queries accurately and ensure they align with the database\u2019s current environment and settings."));
                        break block5;
                    }
                    contents.add(new McpSchema.TextContent(String.valueOf(arguments.get("connection_name")) + " Not Connected!"));
                }
                catch (SQLException | ArgumentException e) {
                    return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent("ERROR: " + ((Throwable)e).getLocalizedMessage()), new McpSchema.TextContent("\nBased on the error thrown, provide the user with a clear explanation of what went wrong. If possible, correct the issue and retry the request")), Boolean.valueOf(true));
                }
            }
            return new McpSchema.CallToolResult(contents, Boolean.valueOf(false));
        });
    }
}

