/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.resourceaccessor;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import liquibase.Scope;
import liquibase.resource.AbstractPathResourceAccessor;
import liquibase.resource.PathResource;
import liquibase.resource.Resource;

public class SqlClDirectoryResourceAccessor
extends AbstractPathResourceAccessor {
    private final Path rootDirectory;

    public SqlClDirectoryResourceAccessor(File directory) throws FileNotFoundException {
        this(directory.toPath());
    }

    public SqlClDirectoryResourceAccessor(Path directory) throws FileNotFoundException {
        if (directory == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        directory = directory.normalize().toAbsolutePath();
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Creating resourceAccessor for directory " + String.valueOf(directory));
        this.rootDirectory = directory;
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new FileNotFoundException("Non-existent directory: " + String.valueOf(directory.toAbsolutePath()));
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + String.valueOf(directory.toAbsolutePath()));
        }
    }

    public void close() throws Exception {
    }

    protected Path getRootPath() {
        return this.rootDirectory;
    }

    protected Resource createResource(Path file, String pathToAdd) {
        return new PathResource(pathToAdd, file);
    }

    public Path getRoot() {
        return this.getRootPath();
    }
}

