/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.generator;

import java.util.LinkedList;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import oracle.dbtools.raptor.liquibase.generator.MetadataSqlGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.util.Logger;

public abstract class AbstractCommonPlSqlGenerator<StatementType extends SqlStatement>
extends AbstractSqlGenerator<AbstractCommonPlSqlStatement> {
    public ValidationErrors validate(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors priorErrors = statement.getValidation();
        ValidationErrors validationErrors = new ValidationErrors();
        if (priorErrors != null) {
            return priorErrors;
        }
        validationErrors.checkRequiredField("objectName", (Object)statement.getObjectName());
        validationErrors.checkRequiredField("ownerName", (Object)statement.getOwnerName());
        if (validationErrors.hasErrors()) {
            statement.setValidation(validationErrors);
            return validationErrors;
        }
        if (ACTIONS.CREATE == this.createOrDrop()) {
            try {
                if (statement.getSqls() == null) {
                    statement.setSqls(MetadataSqlGenerator.getCreateSqlPlSql(statement, database));
                }
            }
            catch (Exception e) {
                validationErrors.addError(LbUtils.getRoot(e).getMessage());
                statement.setValidation(validationErrors);
            }
        } else {
            try {
                if (statement.getSqls() == null) {
                    statement.setSqls(MetadataSqlGenerator.getDropSqlPlSql(statement, database));
                }
            }
            catch (Exception e) {
                validationErrors.addError(LbUtils.getRoot(e).getMessage());
                statement.setValidation(validationErrors);
            }
        }
        return validationErrors;
    }

    /*
     * Unable to fully structure code
     */
    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        if (!(database instanceof OracleDatabase)) {
            return new Sql[0];
        }
        sqls = null;
        if (ACTIONS.CREATE == this.createOrDrop()) {
            try {
                if (statement.getSqls() != null) ** GOTO lbl19
                sqls = MetadataSqlGenerator.getCreateSqlPlSql(statement, database);
            }
            catch (Exception e) {
                Logger.warn(AbstractCommonPlSqlGenerator.class, (Throwable)e);
                return AbstractCommonPlSqlGenerator.EMPTY_SQL;
            }
        } else {
            try {
                if (statement.getSqls() == null) {
                    sqls = MetadataSqlGenerator.getDropSqlPlSql(statement, database);
                }
            }
            catch (Exception e) {
                Logger.warn(AbstractCommonPlSqlGenerator.class, (Throwable)e);
                return AbstractCommonPlSqlGenerator.EMPTY_SQL;
            }
        }
lbl19:
        // 3 sources

        stmts = new LinkedList<UnparsedSql>();
        if (sqls != null) {
            for (Sql sql : sqls) {
                if (sql == null) continue;
                sqlString = statement.getObjectType().equals("ROLE_GRANT") != false || statement.getObjectType().equals("SYSTEM_GRANT") != false ? LbUtils.replaceUserSchemaGrants(sql.toSql(), statement.getOwnerName()) : LbUtils.replaceUserSchema(sql.toSql(), statement.getOwnerName());
                stmts.add(new UnparsedSql(sqlString, new DatabaseObject[0]));
            }
            return stmts.toArray(new Sql[0]);
        }
        return new Sql[0];
    }

    public abstract ACTIONS createOrDrop();

    public static enum ACTIONS {
        CREATE,
        DROP;

    }
}

