/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RuntimeStatement;
import liquibase.util.StringUtil;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

@DatabaseChange(name="oracleOutput", description="Logs a message and continues execution.", priority=1)
public class OracleOutputChange
extends AbstractChange {
    private String message;
    private String target;

    public ValidationErrors validate(Database database) {
        ValidationErrors validate = new ValidationErrors((Change)this);
        validate.checkRequiredField("message", (Object)this.getMessage());
        return validate;
    }

    @DatabaseChangeProperty(description="Message to send to output", exampleValue="Make sure you feed the cat", serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = StringUtil.trimToNull((String)message);
    }

    protected Change[] createInverses() {
        return EMPTY_CHANGE;
    }

    public Object getSerializableFieldValue(String field) {
        Object value = super.getSerializableFieldValue(field);
        if ("target".equals(field) && "".equals(value)) {
            return null;
        }
        return value;
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    public String getConfirmationMessage() {
        return "Output: " + this.getMessage();
    }

    private void write() {
        if (LbUtils.getContext() != null && LbUtils.getContext().getOutputStream() != null) {
            LbUtils.getContext().consumerRuning(true);
            LbUtils.getContext().writeln(this.getMessage());
        } else {
            Scope.getCurrentScope().getUI().sendMessage(this.getMessage());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("output buffer or context not set outputing thru liquibase scope");
        }
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RuntimeStatement(){

            public Sql[] generate(Database database) {
                if (OracleOutputChange.this.target == null) {
                    OracleOutputChange.this.target = "SQLCL";
                }
                if ("STDOUT".equalsIgnoreCase(OracleOutputChange.this.target)) {
                    OracleOutputChange.this.write();
                } else if ("STDERR".equalsIgnoreCase(OracleOutputChange.this.target)) {
                    OracleOutputChange.this.write();
                } else if ("SQLCL".equalsIgnoreCase(OracleOutputChange.this.target)) {
                    OracleOutputChange.this.write();
                } else if ("DEBUG".equalsIgnoreCase(OracleOutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine(OracleOutputChange.this.getMessage());
                } else if ("INFO".equalsIgnoreCase(OracleOutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(OracleOutputChange.this.getMessage());
                } else if ("WARN".equalsIgnoreCase(OracleOutputChange.this.target) || "WARNING".equalsIgnoreCase(OracleOutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(OracleOutputChange.this.getMessage());
                } else if ("SEVERE".equalsIgnoreCase(OracleOutputChange.this.target) || "FATAL".equalsIgnoreCase(OracleOutputChange.this.target) || "ERROR".equalsIgnoreCase(OracleOutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe(OracleOutputChange.this.getMessage());
                } else {
                    throw new UnexpectedLiquibaseException("Unknown target: " + OracleOutputChange.this.target);
                }
                return null;
            }
        }};
    }

    @DatabaseChangeProperty(description="Target for message. Possible values: SQLCL, STDOUT, STDERR, FATAL, WARN, INFO, DEBUG. Default: SQLCL", exampleValue="SQLCL")
    public String getTarget() {
        if (this.target == null) {
            return "SQLCL";
        }
        return this.target;
    }

    public void setTarget(String target) {
        this.target = StringUtil.trimToNull((String)target);
    }
}

