/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import liquibase.Scope;
import liquibase.configuration.AbstractMapConfigurationValueProvider;
import liquibase.exception.CommandExecutionException;
import liquibase.ui.LoggerUIService;
import oracle.dbtools.raptor.liquibase.changelog.visitor.OracleChangeExecListener;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class SqlClConfigurationProvider
extends AbstractMapConfigurationValueProvider {
    final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Map<String, Object> parms = new HashMap<String, Object>();

    public SqlClConfigurationProvider(ScriptRunnerContext ctx, Map<String, Object> map, String propertyFileName) throws IOException, CommandExecutionException {
        File propertyFile;
        if (propertyFileName != null && (propertyFile = Paths.get(propertyFileName, new String[0]).isAbsolute() ? new File(propertyFileName) : new File(LbUtils.getCWD(), propertyFileName)).exists()) {
            try (FileInputStream stream = new FileInputStream(propertyFile);){
                Properties props = new Properties();
                props.load(stream);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = ((String)entry.getKey()).replaceFirst("^parameter.", "");
                    Object value = entry.getValue();
                    if (value instanceof Date) {
                        try {
                            value = this.formatter.parse(value.toString());
                        }
                        catch (ParseException e) {
                            throw new CommandExecutionException("Unable to format date parameter.");
                        }
                        this.parms.put(key, value);
                        continue;
                    }
                    this.parms.put(key, value);
                }
            }
        }
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.parms.put(entry.getKey(), entry.getValue());
            }
        }
        this.parms.put("liquibase.command.changeExecListener", (Object)new OracleChangeExecListener());
        this.parms.put(LBOptions.Options.SQLCLVERSION.toString(), Messages.getString("SQLCLVERSION"));
        this.parms.put("liquibase.uiService", "LOGGER");
        this.parms.put("liquibase.sqlLogLevelL", "OFF");
        this.parms.put("liquibase.logLevel", "OFF");
        this.parms.put("liquibase,logChannels", "ALL");
        this.parms.put(Scope.Attr.ui.name(), new LoggerUIService());
    }

    public int getPrecedence() {
        return 600;
    }

    protected String getSourceDescription() {
        return "Sqlcl data value provider";
    }

    protected Map<String, Object> getMap() {
        return this.parms;
    }

    public void put(String key, Object value) {
        this.parms.put(key, value);
    }

    public Object get(String key) {
        return this.parms.get(key);
    }
}

