/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.util;

import java.util.Objects;
import java.util.function.Function;
import net.ucanaccess.util.IThrowingConsumer;
import net.ucanaccess.util.IThrowingFunction;
import net.ucanaccess.util.IThrowingRunnable;
import net.ucanaccess.util.IThrowingSupplier;

public final class Try<V, EC extends Throwable> {
    private final V val;
    private final EC t;

    private Try(IThrowingSupplier<V, EC> _catchable) {
        Object locVal = null;
        Throwable locEx = null;
        try {
            locVal = _catchable.get();
        }
        catch (Throwable _ex) {
            Throwable castEx;
            locEx = castEx = _ex;
        }
        this.val = locVal;
        this.t = locEx;
    }

    private Try(V _val, EC _ex) {
        this.val = _val;
        this.t = _ex;
    }

    public static <R, EC extends Throwable> Try<R, EC> catching(IThrowingSupplier<R, EC> _catchable) {
        return new Try<R, EC>(Objects.requireNonNull(_catchable, "Supplier required"));
    }

    public static <EC extends Throwable> Try<Void, EC> catching(IThrowingRunnable<EC> _catchable) {
        Objects.requireNonNull(_catchable, "Runnable required");
        return new Try(() -> {
            _catchable.run();
            return null;
        });
    }

    public static <R extends AutoCloseable, ES extends Throwable, V, EC extends Throwable> Try<V, EC> withResources(IThrowingSupplier<R, ES> _resourceSupplier, IThrowingFunction<R, V, EC> _catchable) {
        Objects.requireNonNull(_resourceSupplier, "Resource supplier required");
        Objects.requireNonNull(_catchable, "Resource consumer required");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (AutoCloseable r = (AutoCloseable)_resourceSupplier.get();){
                V locVal = null;
                Throwable locEx = null;
                try {
                    locVal = _catchable.apply(r);
                }
                catch (Throwable _ex) {
                    Throwable castEx;
                    locEx = castEx = _ex;
                }
                return new Try<Object, Throwable>(locVal, locEx);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable _ex) {
            Try.doThrow(_ex);
            return null;
        }
    }

    public static <R extends AutoCloseable, ES extends Throwable, EC extends Throwable> Try<Void, EC> withResources(IThrowingSupplier<R, ES> _resourceSupplier, IThrowingConsumer<R, EC> _catchable) {
        Objects.requireNonNull(_resourceSupplier, "Resource supplier required");
        Objects.requireNonNull(_catchable, "Resource consumer required");
        return Try.withResources(_resourceSupplier, (R i) -> {
            _catchable.accept(i);
            return null;
        });
    }

    public <V1, E1 extends Throwable> Try<V1, E1> map(Function<? super V, ? extends V1> _mapper) {
        Objects.requireNonNull(_mapper, "Mapper required");
        if (this.t != null) {
            EC e1 = this.t;
            return new Try<Object, EC>(null, e1);
        }
        return Try.catching(() -> _mapper.apply((V)this.val));
    }

    public V get() {
        if (this.hasThrown()) {
            Try.doThrow(this.t);
        }
        return this.val;
    }

    public EC getException() {
        return this.t;
    }

    boolean hasThrown() {
        return this.t != null;
    }

    public V orElse(V _other) {
        return this.hasThrown() ? _other : this.val;
    }

    public void orElse(IThrowingConsumer<EC, Throwable> _consumer) {
        if (this.hasThrown()) {
            Try.catching(() -> _consumer.accept(this.t)).orThrow();
        }
    }

    public V orElseApply(IThrowingFunction<EC, V, Throwable> _function) {
        if (this.hasThrown()) {
            return (V)Try.catching(() -> _function.apply(this.t)).orThrow();
        }
        return this.val;
    }

    public V orElseGet(IThrowingSupplier<V, Throwable> _supplier) {
        if (this.hasThrown()) {
            return Try.catching(_supplier).orThrow();
        }
        return this.val;
    }

    public V orIgnore() {
        return this.hasThrown() ? null : (V)this.val;
    }

    public V orThrow() {
        if (this.hasThrown()) {
            Try.doThrow(this.t);
        }
        return this.val;
    }

    public <T2 extends Throwable> V orThrow(Function<EC, T2> _function) throws T2 {
        Objects.requireNonNull(_function, "Function required");
        if (this.hasThrown()) {
            Throwable t2 = (Throwable)_function.apply(this.t);
            Try.doThrow(Objects.requireNonNullElseGet(t2, () -> new IllegalStateException("Function must provide a throwable")));
        }
        return this.val;
    }

    public String toString() {
        return String.format("%s[val=%s, ex=%s]", this.getClass().getSimpleName(), this.val, this.t);
    }

    private static <T extends Throwable> RuntimeException doThrow(Throwable _t) throws T {
        throw _t;
    }
}

