/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.type;

import com.healthmarketscience.jackcess.Database;
import java.util.List;

public enum AccessVersion {
    V2000(Database.FileFormat.V2000),
    V2003(Database.FileFormat.V2003),
    V2007(Database.FileFormat.V2007),
    V2010(Database.FileFormat.V2010),
    V2016(Database.FileFormat.V2016);

    static final AccessVersion DEFAULT_ACCESS_VERSION;
    private final Database.FileFormat fileFormat;

    static {
        DEFAULT_ACCESS_VERSION = V2003;
    }

    private AccessVersion(Database.FileFormat _fileFormat) {
        this.fileFormat = _fileFormat;
    }

    public Database.FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static List<AccessVersion> getDefaultAccessVersion() {
        return List.of(DEFAULT_ACCESS_VERSION);
    }

    public static AccessVersion parse(String _val) {
        if (_val == null) {
            return null;
        }
        String val = _val.strip().toLowerCase();
        AccessVersion[] accessVersionArray = AccessVersion.values();
        int n = accessVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessVersion ver = accessVersionArray[n2];
            if (val.equals(ver.name())) {
                return ver;
            }
            ++n2;
        }
        return null;
    }
}

