/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Cursor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ucanaccess.commands.CompositeFeedbackAction;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.ICursorCommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.commands.IndexSelector;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Try;

public class CompositeCommand
implements ICommand {
    private List<ICursorCommand> composite = new ArrayList<ICursorCommand>();
    private Map<String, Object> currentRow;
    private String execId;
    private IndexSelector indexSelector;
    private List<ICursorCommand> rollbackCache = new ArrayList<ICursorCommand>();

    public boolean add(ICursorCommand c4io) {
        if (this.indexSelector == null) {
            this.indexSelector = c4io.getIndexSelector();
            this.execId = c4io.getExecId();
        }
        return this.composite.add(c4io);
    }

    public List<ICursorCommand> getComposite() {
        return this.composite;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.composite.get(0).getTableName();
    }

    @Override
    public ICommand.CommandType getType() {
        return ICommand.CommandType.COMPOSITE;
    }

    public boolean moveToNextRow(Cursor cur, Set<String> columnNames) throws IOException {
        boolean hasNext = cur.moveToNextRow();
        if (hasNext) {
            this.currentRow = cur.getCurrentRow(columnNames);
        }
        return hasNext;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        return Try.catching(() -> {
            CompositeFeedbackAction cfa = new CompositeFeedbackAction();
            Cursor cur = this.indexSelector.getCursor();
            cur.beforeFirst();
            Set<String> columnNames = this.composite.get(0).getRowPattern().keySet();
            block0: while (!this.composite.isEmpty() && this.moveToNextRow(cur, columnNames)) {
                Iterator<ICursorCommand> it = this.composite.iterator();
                while (it.hasNext()) {
                    ICursorCommand comm = it.next();
                    if (!comm.currentRowMatches(cur, this.currentRow)) continue;
                    cfa.add(comm.persistCurrentRow(cur));
                    it.remove();
                    this.rollbackCache.add(comm);
                    continue block0;
                }
            }
            return cfa;
        }).orThrow(UcanaccessSQLException::new);
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        for (ICursorCommand ic : this.rollbackCache) {
            ic.rollback();
        }
        return null;
    }
}

