/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.ConsoleHistory;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UpdateConsoleHistoryResponse
extends BmcResponse {
    private String opcWorkRequestId;
    private String opcRequestId;
    private String etag;
    private ConsoleHistory consoleHistory;

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public ConsoleHistory getConsoleHistory() {
        return this.consoleHistory;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcWorkRequestId", "opcRequestId", "etag", "consoleHistory"})
    private UpdateConsoleHistoryResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcWorkRequestId, String opcRequestId, String etag, ConsoleHistory consoleHistory) {
        super(__httpStatusCode__, headers);
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.consoleHistory = consoleHistory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",consoleHistory=").append(String.valueOf((Object)this.consoleHistory));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateConsoleHistoryResponse)) {
            return false;
        }
        UpdateConsoleHistoryResponse other = (UpdateConsoleHistoryResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.consoleHistory, (Object)other.consoleHistory);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.consoleHistory == null ? 43 : this.consoleHistory.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<UpdateConsoleHistoryResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcWorkRequestId;
        private String opcRequestId;
        private String etag;
        private ConsoleHistory consoleHistory;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder consoleHistory(ConsoleHistory consoleHistory) {
            this.consoleHistory = consoleHistory;
            return this;
        }

        public Builder copy(UpdateConsoleHistoryResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.consoleHistory(o.getConsoleHistory());
            return this;
        }

        public UpdateConsoleHistoryResponse build() {
            return new UpdateConsoleHistoryResponse(this.__httpStatusCode__, this.headers, this.opcWorkRequestId, this.opcRequestId, this.etag, this.consoleHistory);
        }
    }
}

