/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAutonomousDatabasesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String autonomousContainerDatabaseId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private AutonomousDatabaseSummary.InfrastructureType infrastructureType;
    private AutonomousDatabaseSummary.LifecycleState lifecycleState;
    private AutonomousDatabaseSummary.LifecycleState lifecycleStateNotEqualTo;
    private AutonomousDatabaseSummary.DbWorkload dbWorkload;
    private String dbVersion;
    private Boolean isFreeTier;
    private String displayName;
    private String opcRequestId;
    private Boolean isRefreshableClone;
    private Boolean isDataGuardEnabled;
    private Boolean isResourcePoolLeader;
    private String resourcePoolLeaderId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousContainerDatabaseId() {
        return this.autonomousContainerDatabaseId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public AutonomousDatabaseSummary.InfrastructureType getInfrastructureType() {
        return this.infrastructureType;
    }

    public AutonomousDatabaseSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public AutonomousDatabaseSummary.LifecycleState getLifecycleStateNotEqualTo() {
        return this.lifecycleStateNotEqualTo;
    }

    public AutonomousDatabaseSummary.DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public Boolean getIsFreeTier() {
        return this.isFreeTier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsRefreshableClone() {
        return this.isRefreshableClone;
    }

    public Boolean getIsDataGuardEnabled() {
        return this.isDataGuardEnabled;
    }

    public Boolean getIsResourcePoolLeader() {
        return this.isResourcePoolLeader;
    }

    public String getResourcePoolLeaderId() {
        return this.resourcePoolLeaderId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).autonomousContainerDatabaseId(this.autonomousContainerDatabaseId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).infrastructureType(this.infrastructureType).lifecycleState(this.lifecycleState).lifecycleStateNotEqualTo(this.lifecycleStateNotEqualTo).dbWorkload(this.dbWorkload).dbVersion(this.dbVersion).isFreeTier(this.isFreeTier).displayName(this.displayName).opcRequestId(this.opcRequestId).isRefreshableClone(this.isRefreshableClone).isDataGuardEnabled(this.isDataGuardEnabled).isResourcePoolLeader(this.isResourcePoolLeader).resourcePoolLeaderId(this.resourcePoolLeaderId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",autonomousContainerDatabaseId=").append(String.valueOf(this.autonomousContainerDatabaseId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",infrastructureType=").append(String.valueOf((Object)this.infrastructureType));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",lifecycleStateNotEqualTo=").append(String.valueOf((Object)this.lifecycleStateNotEqualTo));
        sb.append(",dbWorkload=").append(String.valueOf((Object)this.dbWorkload));
        sb.append(",dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(",isFreeTier=").append(String.valueOf(this.isFreeTier));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isRefreshableClone=").append(String.valueOf(this.isRefreshableClone));
        sb.append(",isDataGuardEnabled=").append(String.valueOf(this.isDataGuardEnabled));
        sb.append(",isResourcePoolLeader=").append(String.valueOf(this.isResourcePoolLeader));
        sb.append(",resourcePoolLeaderId=").append(String.valueOf(this.resourcePoolLeaderId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAutonomousDatabasesRequest)) {
            return false;
        }
        ListAutonomousDatabasesRequest other = (ListAutonomousDatabasesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.autonomousContainerDatabaseId, other.autonomousContainerDatabaseId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.infrastructureType, (Object)other.infrastructureType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifecycleStateNotEqualTo, (Object)other.lifecycleStateNotEqualTo) && Objects.equals((Object)this.dbWorkload, (Object)other.dbWorkload) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.isFreeTier, other.isFreeTier) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isRefreshableClone, other.isRefreshableClone) && Objects.equals(this.isDataGuardEnabled, other.isDataGuardEnabled) && Objects.equals(this.isResourcePoolLeader, other.isResourcePoolLeader) && Objects.equals(this.resourcePoolLeaderId, other.resourcePoolLeaderId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.autonomousContainerDatabaseId == null ? 43 : this.autonomousContainerDatabaseId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.infrastructureType == null ? 43 : this.infrastructureType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleStateNotEqualTo == null ? 43 : this.lifecycleStateNotEqualTo.hashCode());
        result = result * 59 + (this.dbWorkload == null ? 43 : this.dbWorkload.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.isFreeTier == null ? 43 : this.isFreeTier.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isRefreshableClone == null ? 43 : this.isRefreshableClone.hashCode());
        result = result * 59 + (this.isDataGuardEnabled == null ? 43 : this.isDataGuardEnabled.hashCode());
        result = result * 59 + (this.isResourcePoolLeader == null ? 43 : this.isResourcePoolLeader.hashCode());
        result = result * 59 + (this.resourcePoolLeaderId == null ? 43 : this.resourcePoolLeaderId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousDatabasesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String autonomousContainerDatabaseId = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private AutonomousDatabaseSummary.InfrastructureType infrastructureType = null;
        private AutonomousDatabaseSummary.LifecycleState lifecycleState = null;
        private AutonomousDatabaseSummary.LifecycleState lifecycleStateNotEqualTo = null;
        private AutonomousDatabaseSummary.DbWorkload dbWorkload = null;
        private String dbVersion = null;
        private Boolean isFreeTier = null;
        private String displayName = null;
        private String opcRequestId = null;
        private Boolean isRefreshableClone = null;
        private Boolean isDataGuardEnabled = null;
        private Boolean isResourcePoolLeader = null;
        private String resourcePoolLeaderId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder autonomousContainerDatabaseId(String autonomousContainerDatabaseId) {
            this.autonomousContainerDatabaseId = autonomousContainerDatabaseId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder infrastructureType(AutonomousDatabaseSummary.InfrastructureType infrastructureType) {
            this.infrastructureType = infrastructureType;
            return this;
        }

        public Builder lifecycleState(AutonomousDatabaseSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder lifecycleStateNotEqualTo(AutonomousDatabaseSummary.LifecycleState lifecycleStateNotEqualTo) {
            this.lifecycleStateNotEqualTo = lifecycleStateNotEqualTo;
            return this;
        }

        public Builder dbWorkload(AutonomousDatabaseSummary.DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            return this;
        }

        public Builder isFreeTier(Boolean isFreeTier) {
            this.isFreeTier = isFreeTier;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isRefreshableClone(Boolean isRefreshableClone) {
            this.isRefreshableClone = isRefreshableClone;
            return this;
        }

        public Builder isDataGuardEnabled(Boolean isDataGuardEnabled) {
            this.isDataGuardEnabled = isDataGuardEnabled;
            return this;
        }

        public Builder isResourcePoolLeader(Boolean isResourcePoolLeader) {
            this.isResourcePoolLeader = isResourcePoolLeader;
            return this;
        }

        public Builder resourcePoolLeaderId(String resourcePoolLeaderId) {
            this.resourcePoolLeaderId = resourcePoolLeaderId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousDatabasesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.autonomousContainerDatabaseId(o.getAutonomousContainerDatabaseId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.infrastructureType(o.getInfrastructureType());
            this.lifecycleState(o.getLifecycleState());
            this.lifecycleStateNotEqualTo(o.getLifecycleStateNotEqualTo());
            this.dbWorkload(o.getDbWorkload());
            this.dbVersion(o.getDbVersion());
            this.isFreeTier(o.getIsFreeTier());
            this.displayName(o.getDisplayName());
            this.opcRequestId(o.getOpcRequestId());
            this.isRefreshableClone(o.getIsRefreshableClone());
            this.isDataGuardEnabled(o.getIsDataGuardEnabled());
            this.isResourcePoolLeader(o.getIsResourcePoolLeader());
            this.resourcePoolLeaderId(o.getResourcePoolLeaderId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousDatabasesRequest build() {
            ListAutonomousDatabasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAutonomousDatabasesRequest buildWithoutInvocationCallback() {
            ListAutonomousDatabasesRequest request = new ListAutonomousDatabasesRequest();
            request.compartmentId = this.compartmentId;
            request.autonomousContainerDatabaseId = this.autonomousContainerDatabaseId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.infrastructureType = this.infrastructureType;
            request.lifecycleState = this.lifecycleState;
            request.lifecycleStateNotEqualTo = this.lifecycleStateNotEqualTo;
            request.dbWorkload = this.dbWorkload;
            request.dbVersion = this.dbVersion;
            request.isFreeTier = this.isFreeTier;
            request.displayName = this.displayName;
            request.opcRequestId = this.opcRequestId;
            request.isRefreshableClone = this.isRefreshableClone;
            request.isDataGuardEnabled = this.isDataGuardEnabled;
            request.isResourcePoolLeader = this.isResourcePoolLeader;
            request.resourcePoolLeaderId = this.resourcePoolLeaderId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

