/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.Month;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateSchedulingPolicyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="cadence")
    private final Cadence cadence;
    @JsonProperty(value="cadenceStartMonth")
    private final Month cadenceStartMonth;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "cadence", "cadenceStartMonth", "freeformTags", "definedTags"})
    public UpdateSchedulingPolicyDetails(String displayName, Cadence cadence, Month cadenceStartMonth, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.cadence = cadence;
        this.cadenceStartMonth = cadenceStartMonth;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Cadence getCadence() {
        return this.cadence;
    }

    public Month getCadenceStartMonth() {
        return this.cadenceStartMonth;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSchedulingPolicyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", cadence=").append(String.valueOf((Object)this.cadence));
        sb.append(", cadenceStartMonth=").append(String.valueOf((Object)this.cadenceStartMonth));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSchedulingPolicyDetails)) {
            return false;
        }
        UpdateSchedulingPolicyDetails other = (UpdateSchedulingPolicyDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.cadence, (Object)other.cadence) && Objects.equals((Object)this.cadenceStartMonth, (Object)other.cadenceStartMonth) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.cadence == null ? 43 : this.cadence.hashCode());
        result = result * 59 + (this.cadenceStartMonth == null ? 43 : this.cadenceStartMonth.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Cadence implements BmcEnum
    {
        Halfyearly("HALFYEARLY"),
        Quarterly("QUARTERLY"),
        Monthly("MONTHLY");

        private final String value;
        private static Map<String, Cadence> map;

        private Cadence(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Cadence create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Cadence: " + key);
        }

        static {
            map = new HashMap<String, Cadence>();
            for (Cadence v : Cadence.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="cadence")
        private Cadence cadence;
        @JsonProperty(value="cadenceStartMonth")
        private Month cadenceStartMonth;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder cadence(Cadence cadence) {
            this.cadence = cadence;
            this.__explicitlySet__.add("cadence");
            return this;
        }

        public Builder cadenceStartMonth(Month cadenceStartMonth) {
            this.cadenceStartMonth = cadenceStartMonth;
            this.__explicitlySet__.add("cadenceStartMonth");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateSchedulingPolicyDetails build() {
            UpdateSchedulingPolicyDetails model = new UpdateSchedulingPolicyDetails(this.displayName, this.cadence, this.cadenceStartMonth, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateSchedulingPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("cadence")) {
                this.cadence(model.getCadence());
            }
            if (model.wasPropertyExplicitlySet("cadenceStartMonth")) {
                this.cadenceStartMonth(model.getCadenceStartMonth());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

