/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DbServerHistorySummary;
import com.oracle.bmc.database.model.GranularMaintenanceHistoryDetails;
import com.oracle.bmc.database.model.MaintenanceRunSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaintenanceRunHistorySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="maintenanceRunDetails")
    private final MaintenanceRunSummary maintenanceRunDetails;
    @JsonProperty(value="dbServersHistoryDetails")
    private final List<DbServerHistorySummary> dbServersHistoryDetails;
    @JsonProperty(value="currentExecutionWindow")
    private final String currentExecutionWindow;
    @JsonProperty(value="granularMaintenanceHistory")
    private final List<GranularMaintenanceHistoryDetails> granularMaintenanceHistory;

    @Deprecated
    @ConstructorProperties(value={"id", "maintenanceRunDetails", "dbServersHistoryDetails", "currentExecutionWindow", "granularMaintenanceHistory"})
    public MaintenanceRunHistorySummary(String id, MaintenanceRunSummary maintenanceRunDetails, List<DbServerHistorySummary> dbServersHistoryDetails, String currentExecutionWindow, List<GranularMaintenanceHistoryDetails> granularMaintenanceHistory) {
        this.id = id;
        this.maintenanceRunDetails = maintenanceRunDetails;
        this.dbServersHistoryDetails = dbServersHistoryDetails;
        this.currentExecutionWindow = currentExecutionWindow;
        this.granularMaintenanceHistory = granularMaintenanceHistory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public MaintenanceRunSummary getMaintenanceRunDetails() {
        return this.maintenanceRunDetails;
    }

    public List<DbServerHistorySummary> getDbServersHistoryDetails() {
        return this.dbServersHistoryDetails;
    }

    public String getCurrentExecutionWindow() {
        return this.currentExecutionWindow;
    }

    public List<GranularMaintenanceHistoryDetails> getGranularMaintenanceHistory() {
        return this.granularMaintenanceHistory;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaintenanceRunHistorySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", maintenanceRunDetails=").append(String.valueOf((Object)this.maintenanceRunDetails));
        sb.append(", dbServersHistoryDetails=").append(String.valueOf(this.dbServersHistoryDetails));
        sb.append(", currentExecutionWindow=").append(String.valueOf(this.currentExecutionWindow));
        sb.append(", granularMaintenanceHistory=").append(String.valueOf(this.granularMaintenanceHistory));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaintenanceRunHistorySummary)) {
            return false;
        }
        MaintenanceRunHistorySummary other = (MaintenanceRunHistorySummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.maintenanceRunDetails, (Object)other.maintenanceRunDetails) && Objects.equals(this.dbServersHistoryDetails, other.dbServersHistoryDetails) && Objects.equals(this.currentExecutionWindow, other.currentExecutionWindow) && Objects.equals(this.granularMaintenanceHistory, other.granularMaintenanceHistory) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.maintenanceRunDetails == null ? 43 : this.maintenanceRunDetails.hashCode());
        result = result * 59 + (this.dbServersHistoryDetails == null ? 43 : this.dbServersHistoryDetails.hashCode());
        result = result * 59 + (this.currentExecutionWindow == null ? 43 : this.currentExecutionWindow.hashCode());
        result = result * 59 + (this.granularMaintenanceHistory == null ? 43 : this.granularMaintenanceHistory.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="maintenanceRunDetails")
        private MaintenanceRunSummary maintenanceRunDetails;
        @JsonProperty(value="dbServersHistoryDetails")
        private List<DbServerHistorySummary> dbServersHistoryDetails;
        @JsonProperty(value="currentExecutionWindow")
        private String currentExecutionWindow;
        @JsonProperty(value="granularMaintenanceHistory")
        private List<GranularMaintenanceHistoryDetails> granularMaintenanceHistory;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder maintenanceRunDetails(MaintenanceRunSummary maintenanceRunDetails) {
            this.maintenanceRunDetails = maintenanceRunDetails;
            this.__explicitlySet__.add("maintenanceRunDetails");
            return this;
        }

        public Builder dbServersHistoryDetails(List<DbServerHistorySummary> dbServersHistoryDetails) {
            this.dbServersHistoryDetails = dbServersHistoryDetails;
            this.__explicitlySet__.add("dbServersHistoryDetails");
            return this;
        }

        public Builder currentExecutionWindow(String currentExecutionWindow) {
            this.currentExecutionWindow = currentExecutionWindow;
            this.__explicitlySet__.add("currentExecutionWindow");
            return this;
        }

        public Builder granularMaintenanceHistory(List<GranularMaintenanceHistoryDetails> granularMaintenanceHistory) {
            this.granularMaintenanceHistory = granularMaintenanceHistory;
            this.__explicitlySet__.add("granularMaintenanceHistory");
            return this;
        }

        public MaintenanceRunHistorySummary build() {
            MaintenanceRunHistorySummary model = new MaintenanceRunHistorySummary(this.id, this.maintenanceRunDetails, this.dbServersHistoryDetails, this.currentExecutionWindow, this.granularMaintenanceHistory);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaintenanceRunHistorySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("maintenanceRunDetails")) {
                this.maintenanceRunDetails(model.getMaintenanceRunDetails());
            }
            if (model.wasPropertyExplicitlySet("dbServersHistoryDetails")) {
                this.dbServersHistoryDetails(model.getDbServersHistoryDetails());
            }
            if (model.wasPropertyExplicitlySet("currentExecutionWindow")) {
                this.currentExecutionWindow(model.getCurrentExecutionWindow());
            }
            if (model.wasPropertyExplicitlySet("granularMaintenanceHistory")) {
                this.granularMaintenanceHistory(model.getGranularMaintenanceHistory());
            }
            return this;
        }
    }
}

