/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DownloadOneoffPatch
extends ExplicitlySetBmcModel {
    @JsonProperty(value="accessUri")
    private final String accessUri;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeExpires")
    private final Date timeExpires;

    @Deprecated
    @ConstructorProperties(value={"accessUri", "timeCreated", "timeExpires"})
    public DownloadOneoffPatch(String accessUri, Date timeCreated, Date timeExpires) {
        this.accessUri = accessUri;
        this.timeCreated = timeCreated;
        this.timeExpires = timeExpires;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAccessUri() {
        return this.accessUri;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeExpires() {
        return this.timeExpires;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DownloadOneoffPatch(");
        sb.append("super=").append(super.toString());
        sb.append("accessUri=").append(String.valueOf(this.accessUri));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeExpires=").append(String.valueOf(this.timeExpires));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadOneoffPatch)) {
            return false;
        }
        DownloadOneoffPatch other = (DownloadOneoffPatch)((Object)o);
        return Objects.equals(this.accessUri, other.accessUri) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeExpires, other.timeExpires) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.accessUri == null ? 43 : this.accessUri.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeExpires == null ? 43 : this.timeExpires.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="accessUri")
        private String accessUri;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeExpires")
        private Date timeExpires;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder accessUri(String accessUri) {
            this.accessUri = accessUri;
            this.__explicitlySet__.add("accessUri");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeExpires(Date timeExpires) {
            this.timeExpires = timeExpires;
            this.__explicitlySet__.add("timeExpires");
            return this;
        }

        public DownloadOneoffPatch build() {
            DownloadOneoffPatch model = new DownloadOneoffPatch(this.accessUri, this.timeCreated, this.timeExpires);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DownloadOneoffPatch model) {
            if (model.wasPropertyExplicitlySet("accessUri")) {
                this.accessUri(model.getAccessUri());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeExpires")) {
                this.timeExpires(model.getTimeExpires());
            }
            return this;
        }
    }
}

