/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateSchedulingPlanDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="schedulingPolicyId")
    private final String schedulingPolicyId;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="serviceType")
    private final ServiceType serviceType;
    @JsonProperty(value="isUsingRecommendedScheduledActions")
    private final Boolean isUsingRecommendedScheduledActions;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "schedulingPolicyId", "resourceId", "serviceType", "isUsingRecommendedScheduledActions", "freeformTags", "definedTags"})
    public CreateSchedulingPlanDetails(String compartmentId, String schedulingPolicyId, String resourceId, ServiceType serviceType, Boolean isUsingRecommendedScheduledActions, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.compartmentId = compartmentId;
        this.schedulingPolicyId = schedulingPolicyId;
        this.resourceId = resourceId;
        this.serviceType = serviceType;
        this.isUsingRecommendedScheduledActions = isUsingRecommendedScheduledActions;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSchedulingPolicyId() {
        return this.schedulingPolicyId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public Boolean getIsUsingRecommendedScheduledActions() {
        return this.isUsingRecommendedScheduledActions;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSchedulingPlanDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", schedulingPolicyId=").append(String.valueOf(this.schedulingPolicyId));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", serviceType=").append(String.valueOf((Object)this.serviceType));
        sb.append(", isUsingRecommendedScheduledActions=").append(String.valueOf(this.isUsingRecommendedScheduledActions));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSchedulingPlanDetails)) {
            return false;
        }
        CreateSchedulingPlanDetails other = (CreateSchedulingPlanDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.schedulingPolicyId, other.schedulingPolicyId) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals((Object)this.serviceType, (Object)other.serviceType) && Objects.equals(this.isUsingRecommendedScheduledActions, other.isUsingRecommendedScheduledActions) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.schedulingPolicyId == null ? 43 : this.schedulingPolicyId.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.serviceType == null ? 43 : this.serviceType.hashCode());
        result = result * 59 + (this.isUsingRecommendedScheduledActions == null ? 43 : this.isUsingRecommendedScheduledActions.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ServiceType implements BmcEnum
    {
        Exacc("EXACC"),
        Exacs("EXACS"),
        Fpppcs("FPPPCS");

        private final String value;
        private static Map<String, ServiceType> map;

        private ServiceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ServiceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ServiceType: " + key);
        }

        static {
            map = new HashMap<String, ServiceType>();
            for (ServiceType v : ServiceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="schedulingPolicyId")
        private String schedulingPolicyId;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="serviceType")
        private ServiceType serviceType;
        @JsonProperty(value="isUsingRecommendedScheduledActions")
        private Boolean isUsingRecommendedScheduledActions;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder schedulingPolicyId(String schedulingPolicyId) {
            this.schedulingPolicyId = schedulingPolicyId;
            this.__explicitlySet__.add("schedulingPolicyId");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder serviceType(ServiceType serviceType) {
            this.serviceType = serviceType;
            this.__explicitlySet__.add("serviceType");
            return this;
        }

        public Builder isUsingRecommendedScheduledActions(Boolean isUsingRecommendedScheduledActions) {
            this.isUsingRecommendedScheduledActions = isUsingRecommendedScheduledActions;
            this.__explicitlySet__.add("isUsingRecommendedScheduledActions");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateSchedulingPlanDetails build() {
            CreateSchedulingPlanDetails model = new CreateSchedulingPlanDetails(this.compartmentId, this.schedulingPolicyId, this.resourceId, this.serviceType, this.isUsingRecommendedScheduledActions, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSchedulingPlanDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("schedulingPolicyId")) {
                this.schedulingPolicyId(model.getSchedulingPolicyId());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("serviceType")) {
                this.serviceType(model.getServiceType());
            }
            if (model.wasPropertyExplicitlySet("isUsingRecommendedScheduledActions")) {
                this.isUsingRecommendedScheduledActions(model.getIsUsingRecommendedScheduledActions());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

