/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DataCollectionOptions;
import com.oracle.bmc.database.model.ExadbVmClusterStorageDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateExadbVmClusterDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="backupSubnetId")
    private final String backupSubnetId;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="sshPublicKeys")
    private final List<String> sshPublicKeys;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="scanListenerPortTcp")
    private final Integer scanListenerPortTcp;
    @JsonProperty(value="scanListenerPortTcpSsl")
    private final Integer scanListenerPortTcpSsl;
    @JsonProperty(value="privateZoneId")
    private final String privateZoneId;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="totalECpuCount")
    private final Integer totalECpuCount;
    @JsonProperty(value="enabledECpuCount")
    private final Integer enabledECpuCount;
    @JsonProperty(value="vmFileSystemStorage")
    private final ExadbVmClusterStorageDetails vmFileSystemStorage;
    @JsonProperty(value="exascaleDbStorageVaultId")
    private final String exascaleDbStorageVaultId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="backupNetworkNsgIds")
    private final List<String> backupNetworkNsgIds;
    @JsonProperty(value="gridImageId")
    private final String gridImageId;
    @JsonProperty(value="systemVersion")
    private final String systemVersion;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="securityAttributes")
    private final Map<String, Map<String, Object>> securityAttributes;
    @JsonProperty(value="dataCollectionOptions")
    private final DataCollectionOptions dataCollectionOptions;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "availabilityDomain", "subnetId", "backupSubnetId", "clusterName", "displayName", "hostname", "domain", "sshPublicKeys", "licenseModel", "timeZone", "scanListenerPortTcp", "scanListenerPortTcpSsl", "privateZoneId", "shape", "nodeCount", "totalECpuCount", "enabledECpuCount", "vmFileSystemStorage", "exascaleDbStorageVaultId", "nsgIds", "backupNetworkNsgIds", "gridImageId", "systemVersion", "freeformTags", "definedTags", "securityAttributes", "dataCollectionOptions"})
    public CreateExadbVmClusterDetails(String compartmentId, String availabilityDomain, String subnetId, String backupSubnetId, String clusterName, String displayName, String hostname, String domain, List<String> sshPublicKeys, LicenseModel licenseModel, String timeZone, Integer scanListenerPortTcp, Integer scanListenerPortTcpSsl, String privateZoneId, String shape, Integer nodeCount, Integer totalECpuCount, Integer enabledECpuCount, ExadbVmClusterStorageDetails vmFileSystemStorage, String exascaleDbStorageVaultId, List<String> nsgIds, List<String> backupNetworkNsgIds, String gridImageId, String systemVersion, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> securityAttributes, DataCollectionOptions dataCollectionOptions) {
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
        this.subnetId = subnetId;
        this.backupSubnetId = backupSubnetId;
        this.clusterName = clusterName;
        this.displayName = displayName;
        this.hostname = hostname;
        this.domain = domain;
        this.sshPublicKeys = sshPublicKeys;
        this.licenseModel = licenseModel;
        this.timeZone = timeZone;
        this.scanListenerPortTcp = scanListenerPortTcp;
        this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
        this.privateZoneId = privateZoneId;
        this.shape = shape;
        this.nodeCount = nodeCount;
        this.totalECpuCount = totalECpuCount;
        this.enabledECpuCount = enabledECpuCount;
        this.vmFileSystemStorage = vmFileSystemStorage;
        this.exascaleDbStorageVaultId = exascaleDbStorageVaultId;
        this.nsgIds = nsgIds;
        this.backupNetworkNsgIds = backupNetworkNsgIds;
        this.gridImageId = gridImageId;
        this.systemVersion = systemVersion;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.securityAttributes = securityAttributes;
        this.dataCollectionOptions = dataCollectionOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getBackupSubnetId() {
        return this.backupSubnetId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Integer getScanListenerPortTcp() {
        return this.scanListenerPortTcp;
    }

    public Integer getScanListenerPortTcpSsl() {
        return this.scanListenerPortTcpSsl;
    }

    public String getPrivateZoneId() {
        return this.privateZoneId;
    }

    public String getShape() {
        return this.shape;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Integer getTotalECpuCount() {
        return this.totalECpuCount;
    }

    public Integer getEnabledECpuCount() {
        return this.enabledECpuCount;
    }

    public ExadbVmClusterStorageDetails getVmFileSystemStorage() {
        return this.vmFileSystemStorage;
    }

    public String getExascaleDbStorageVaultId() {
        return this.exascaleDbStorageVaultId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public List<String> getBackupNetworkNsgIds() {
        return this.backupNetworkNsgIds;
    }

    public String getGridImageId() {
        return this.gridImageId;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSecurityAttributes() {
        return this.securityAttributes;
    }

    public DataCollectionOptions getDataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateExadbVmClusterDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", backupSubnetId=").append(String.valueOf(this.backupSubnetId));
        sb.append(", clusterName=").append(String.valueOf(this.clusterName));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", sshPublicKeys=").append(String.valueOf(this.sshPublicKeys));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", scanListenerPortTcp=").append(String.valueOf(this.scanListenerPortTcp));
        sb.append(", scanListenerPortTcpSsl=").append(String.valueOf(this.scanListenerPortTcpSsl));
        sb.append(", privateZoneId=").append(String.valueOf(this.privateZoneId));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", totalECpuCount=").append(String.valueOf(this.totalECpuCount));
        sb.append(", enabledECpuCount=").append(String.valueOf(this.enabledECpuCount));
        sb.append(", vmFileSystemStorage=").append(String.valueOf((Object)this.vmFileSystemStorage));
        sb.append(", exascaleDbStorageVaultId=").append(String.valueOf(this.exascaleDbStorageVaultId));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", backupNetworkNsgIds=").append(String.valueOf(this.backupNetworkNsgIds));
        sb.append(", gridImageId=").append(String.valueOf(this.gridImageId));
        sb.append(", systemVersion=").append(String.valueOf(this.systemVersion));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", securityAttributes=").append(String.valueOf(this.securityAttributes));
        sb.append(", dataCollectionOptions=").append(String.valueOf((Object)this.dataCollectionOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateExadbVmClusterDetails)) {
            return false;
        }
        CreateExadbVmClusterDetails other = (CreateExadbVmClusterDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.backupSubnetId, other.backupSubnetId) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.domain, other.domain) && Objects.equals(this.sshPublicKeys, other.sshPublicKeys) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals(this.scanListenerPortTcp, other.scanListenerPortTcp) && Objects.equals(this.scanListenerPortTcpSsl, other.scanListenerPortTcpSsl) && Objects.equals(this.privateZoneId, other.privateZoneId) && Objects.equals(this.shape, other.shape) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals(this.totalECpuCount, other.totalECpuCount) && Objects.equals(this.enabledECpuCount, other.enabledECpuCount) && Objects.equals((Object)this.vmFileSystemStorage, (Object)other.vmFileSystemStorage) && Objects.equals(this.exascaleDbStorageVaultId, other.exascaleDbStorageVaultId) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.backupNetworkNsgIds, other.backupNetworkNsgIds) && Objects.equals(this.gridImageId, other.gridImageId) && Objects.equals(this.systemVersion, other.systemVersion) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.securityAttributes, other.securityAttributes) && Objects.equals((Object)this.dataCollectionOptions, (Object)other.dataCollectionOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.backupSubnetId == null ? 43 : this.backupSubnetId.hashCode());
        result = result * 59 + (this.clusterName == null ? 43 : this.clusterName.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.sshPublicKeys == null ? 43 : this.sshPublicKeys.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.scanListenerPortTcp == null ? 43 : this.scanListenerPortTcp.hashCode());
        result = result * 59 + (this.scanListenerPortTcpSsl == null ? 43 : this.scanListenerPortTcpSsl.hashCode());
        result = result * 59 + (this.privateZoneId == null ? 43 : this.privateZoneId.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.totalECpuCount == null ? 43 : this.totalECpuCount.hashCode());
        result = result * 59 + (this.enabledECpuCount == null ? 43 : this.enabledECpuCount.hashCode());
        result = result * 59 + (this.vmFileSystemStorage == null ? 43 : this.vmFileSystemStorage.hashCode());
        result = result * 59 + (this.exascaleDbStorageVaultId == null ? 43 : this.exascaleDbStorageVaultId.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.backupNetworkNsgIds == null ? 43 : this.backupNetworkNsgIds.hashCode());
        result = result * 59 + (this.gridImageId == null ? 43 : this.gridImageId.hashCode());
        result = result * 59 + (this.systemVersion == null ? 43 : this.systemVersion.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.securityAttributes == null ? 43 : this.securityAttributes.hashCode());
        result = result * 59 + (this.dataCollectionOptions == null ? 43 : this.dataCollectionOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE");

        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LicenseModel: " + key);
        }

        static {
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="backupSubnetId")
        private String backupSubnetId;
        @JsonProperty(value="clusterName")
        private String clusterName;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="sshPublicKeys")
        private List<String> sshPublicKeys;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonProperty(value="timeZone")
        private String timeZone;
        @JsonProperty(value="scanListenerPortTcp")
        private Integer scanListenerPortTcp;
        @JsonProperty(value="scanListenerPortTcpSsl")
        private Integer scanListenerPortTcpSsl;
        @JsonProperty(value="privateZoneId")
        private String privateZoneId;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="nodeCount")
        private Integer nodeCount;
        @JsonProperty(value="totalECpuCount")
        private Integer totalECpuCount;
        @JsonProperty(value="enabledECpuCount")
        private Integer enabledECpuCount;
        @JsonProperty(value="vmFileSystemStorage")
        private ExadbVmClusterStorageDetails vmFileSystemStorage;
        @JsonProperty(value="exascaleDbStorageVaultId")
        private String exascaleDbStorageVaultId;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="backupNetworkNsgIds")
        private List<String> backupNetworkNsgIds;
        @JsonProperty(value="gridImageId")
        private String gridImageId;
        @JsonProperty(value="systemVersion")
        private String systemVersion;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="securityAttributes")
        private Map<String, Map<String, Object>> securityAttributes;
        @JsonProperty(value="dataCollectionOptions")
        private DataCollectionOptions dataCollectionOptions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder backupSubnetId(String backupSubnetId) {
            this.backupSubnetId = backupSubnetId;
            this.__explicitlySet__.add("backupSubnetId");
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            this.__explicitlySet__.add("clusterName");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder sshPublicKeys(List<String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            this.__explicitlySet__.add("sshPublicKeys");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.__explicitlySet__.add("timeZone");
            return this;
        }

        public Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            this.__explicitlySet__.add("scanListenerPortTcp");
            return this;
        }

        public Builder scanListenerPortTcpSsl(Integer scanListenerPortTcpSsl) {
            this.scanListenerPortTcpSsl = scanListenerPortTcpSsl;
            this.__explicitlySet__.add("scanListenerPortTcpSsl");
            return this;
        }

        public Builder privateZoneId(String privateZoneId) {
            this.privateZoneId = privateZoneId;
            this.__explicitlySet__.add("privateZoneId");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            this.__explicitlySet__.add("nodeCount");
            return this;
        }

        public Builder totalECpuCount(Integer totalECpuCount) {
            this.totalECpuCount = totalECpuCount;
            this.__explicitlySet__.add("totalECpuCount");
            return this;
        }

        public Builder enabledECpuCount(Integer enabledECpuCount) {
            this.enabledECpuCount = enabledECpuCount;
            this.__explicitlySet__.add("enabledECpuCount");
            return this;
        }

        public Builder vmFileSystemStorage(ExadbVmClusterStorageDetails vmFileSystemStorage) {
            this.vmFileSystemStorage = vmFileSystemStorage;
            this.__explicitlySet__.add("vmFileSystemStorage");
            return this;
        }

        public Builder exascaleDbStorageVaultId(String exascaleDbStorageVaultId) {
            this.exascaleDbStorageVaultId = exascaleDbStorageVaultId;
            this.__explicitlySet__.add("exascaleDbStorageVaultId");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder backupNetworkNsgIds(List<String> backupNetworkNsgIds) {
            this.backupNetworkNsgIds = backupNetworkNsgIds;
            this.__explicitlySet__.add("backupNetworkNsgIds");
            return this;
        }

        public Builder gridImageId(String gridImageId) {
            this.gridImageId = gridImageId;
            this.__explicitlySet__.add("gridImageId");
            return this;
        }

        public Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            this.__explicitlySet__.add("systemVersion");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder securityAttributes(Map<String, Map<String, Object>> securityAttributes) {
            this.securityAttributes = securityAttributes;
            this.__explicitlySet__.add("securityAttributes");
            return this;
        }

        public Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            this.__explicitlySet__.add("dataCollectionOptions");
            return this;
        }

        public CreateExadbVmClusterDetails build() {
            CreateExadbVmClusterDetails model = new CreateExadbVmClusterDetails(this.compartmentId, this.availabilityDomain, this.subnetId, this.backupSubnetId, this.clusterName, this.displayName, this.hostname, this.domain, this.sshPublicKeys, this.licenseModel, this.timeZone, this.scanListenerPortTcp, this.scanListenerPortTcpSsl, this.privateZoneId, this.shape, this.nodeCount, this.totalECpuCount, this.enabledECpuCount, this.vmFileSystemStorage, this.exascaleDbStorageVaultId, this.nsgIds, this.backupNetworkNsgIds, this.gridImageId, this.systemVersion, this.freeformTags, this.definedTags, this.securityAttributes, this.dataCollectionOptions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateExadbVmClusterDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("backupSubnetId")) {
                this.backupSubnetId(model.getBackupSubnetId());
            }
            if (model.wasPropertyExplicitlySet("clusterName")) {
                this.clusterName(model.getClusterName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("sshPublicKeys")) {
                this.sshPublicKeys(model.getSshPublicKeys());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            if (model.wasPropertyExplicitlySet("timeZone")) {
                this.timeZone(model.getTimeZone());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcp")) {
                this.scanListenerPortTcp(model.getScanListenerPortTcp());
            }
            if (model.wasPropertyExplicitlySet("scanListenerPortTcpSsl")) {
                this.scanListenerPortTcpSsl(model.getScanListenerPortTcpSsl());
            }
            if (model.wasPropertyExplicitlySet("privateZoneId")) {
                this.privateZoneId(model.getPrivateZoneId());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("nodeCount")) {
                this.nodeCount(model.getNodeCount());
            }
            if (model.wasPropertyExplicitlySet("totalECpuCount")) {
                this.totalECpuCount(model.getTotalECpuCount());
            }
            if (model.wasPropertyExplicitlySet("enabledECpuCount")) {
                this.enabledECpuCount(model.getEnabledECpuCount());
            }
            if (model.wasPropertyExplicitlySet("vmFileSystemStorage")) {
                this.vmFileSystemStorage(model.getVmFileSystemStorage());
            }
            if (model.wasPropertyExplicitlySet("exascaleDbStorageVaultId")) {
                this.exascaleDbStorageVaultId(model.getExascaleDbStorageVaultId());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("backupNetworkNsgIds")) {
                this.backupNetworkNsgIds(model.getBackupNetworkNsgIds());
            }
            if (model.wasPropertyExplicitlySet("gridImageId")) {
                this.gridImageId(model.getGridImageId());
            }
            if (model.wasPropertyExplicitlySet("systemVersion")) {
                this.systemVersion(model.getSystemVersion());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("securityAttributes")) {
                this.securityAttributes(model.getSecurityAttributes());
            }
            if (model.wasPropertyExplicitlySet("dataCollectionOptions")) {
                this.dataCollectionOptions(model.getDataCollectionOptions());
            }
            return this;
        }
    }
}

