/* iod-telemetry BackupSet.sql version 2019.05.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        select
            decode(bs.con_id,0,'0',con.name) as name
            ,decode(bs.backup_type,'L','REDOLOG','D','FULL','I','INCREMENTAL',bs.backup_type) as backup_type
            ,nvl(to_char(bs.incremental_level),'null') as incremental_level
            ,decode(status,'A',1,0) status
            ,bpd.bytes
        from
             v$containers con
            ,v$backup_set bs
            ,v$backup_piece_details bpd
        where
                bs.con_id = con.con_id (+)
            and bs.con_id = bpd.con_id
            and bs.set_stamp = bpd.set_stamp
            and bs.set_count = bpd.set_count
    ),
    v$metric as (
        select
            'BackupSet.'|| metric_name as metric_name
            ,',"con_name":"'            || nvl(to_char(name             ),'null') || '"' ||
             ',"backup_type":"'         || nvl(to_char(backup_type      ),'null') || '"' ||
             ',"incremental_level":"'   || nvl(to_char(incremental_level),'null') || '"' as metric_dimensions
            ,metric_value  as metric_value
        from (
            select
                 name
                ,backup_type
                ,incremental_level
                ,sum(bytes)                     "Bytes"
                ,count(*)                       "Pieces"
                ,count(*) - sum(status)         "PiecesUnavailable"
            from
                v$metric_history
            group by
                 name
                ,backup_type
                ,incremental_level
        ) unpivot (
            metric_value FOR metric_name IN (
                  "Bytes"
                 ,"Pieces"
                 ,"PiecesUnavailable"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
