/* iod-telemetry ArchiveDest.sql version 2019.05.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        select * from v$archive_dest where status != 'INACTIVE'
    ),
    v$metric as (
        select
            'ArchiveDest' as metric_name
            ,',"dest_name":"'       || nvl(to_char(dest_name        ),'null') || '"' ||
             ',"status":"'          || nvl(to_char(status           ),'null') || '"' ||
             ',"target":"'          || nvl(to_char(target           ),'null') || '"' ||
             ',"archiver":"'        || nvl(to_char(archiver         ),'null') || '"' ||
             ',"schedule":"'        || nvl(to_char(schedule         ),'null') || '"' ||
             ',"transmit_mode":"'   || nvl(to_char(transmit_mode    ),'null') || '"' as metric_dimensions
             ,1 as metric_value
        from v$metric_history
        union
        select
            'ArchiveDest.'|| metric_name as metric_name
            ,',"dest_name":"'      || dest_name        || '"' ||
            ',"status":"'          || status           || '"' ||
            ',"target":"'          || target           || '"' ||
            ',"archiver":"'        || archiver         || '"' ||
            ',"schedule":"'        || schedule         || '"' ||
            ',"transmit_mode":"'   || transmit_mode    || '"' as metric_dimensions
            ,metric_value as metric_value
        from (
            select
                 dest_name
                ,status
                ,target
                ,archiver
                ,schedule
                ,transmit_mode
                ,case
                    when applied_scn !=0 then
                        (cast(scn_to_timestamp(dbms_flashback.get_system_change_number) as date) -
                         cast(scn_to_timestamp(applied_scn) as date))*86400
                    else applied_scn
                end as "AppliedScnLagSeconds"
            from
                v$metric_history
        ) unpivot (
            metric_value FOR metric_name IN (
                "AppliedScnLagSeconds"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
