/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Checksum;

public final class CRC32C
implements Checksum {
    private static final int CRC32C_POLY = 517762881;
    private static final int REVERSED_CRC32C_POLY;
    private static final int[] byteTable;
    private static final int[][] byteTables;
    private static final int[] byteTable0;
    private static final int[] byteTable1;
    private static final int[] byteTable2;
    private static final int[] byteTable3;
    private static final int[] byteTable4;
    private static final int[] byteTable5;
    private static final int[] byteTable6;
    private static final int[] byteTable7;
    private int crc = -1;

    @Override
    public void update(int b) {
        this.crc = this.crc >>> 8 ^ byteTable[(this.crc ^ b & 0xFF) & 0xFF];
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.crc = CRC32C.updateBytes(this.crc, b, off, off + len);
    }

    @Override
    public void update(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        assert (pos <= limit);
        int rem = limit - pos;
        if (rem <= 0) {
            return;
        }
        if (buffer.isDirect()) {
            this.crc = CRC32C.updateDirectByteBuffer(this.crc, buffer, pos, limit);
        } else if (buffer.hasArray()) {
            this.crc = CRC32C.updateBytes(this.crc, buffer.array(), pos + buffer.arrayOffset(), limit + buffer.arrayOffset());
        } else {
            byte[] b = new byte[Math.min(buffer.remaining(), 4096)];
            while (buffer.hasRemaining()) {
                int length = Math.min(buffer.remaining(), b.length);
                buffer.get(b, 0, length);
                this.update(b, 0, length);
            }
        }
        buffer.position(limit);
    }

    @Override
    public void reset() {
        this.crc = -1;
    }

    @Override
    public long getValue() {
        return (long)(~this.crc) & 0xFFFFFFFFL;
    }

    private static int updateBytes(int crc, byte[] b, int off, int end) {
        if (end - off >= 8) {
            int alignLength = 8 - (off & 7) & 7;
            int alignEnd = off + alignLength;
            while (off < alignEnd) {
                crc = crc >>> 8 ^ byteTable[(crc ^ b[off]) & 0xFF];
                ++off;
            }
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                crc = Integer.reverseBytes(crc);
            }
            while (off < end - 8) {
                long value = 0L;
                for (int i = 0; i < 8; ++i) {
                    value |= ((long)b[off + i] & 0xFFL) << i * 8;
                }
                int firstHalf = (int)value;
                int secondHalf = (int)(value >>> 32);
                crc ^= firstHalf;
                crc = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? byteTable7[crc & 0xFF] ^ byteTable6[crc >>> 8 & 0xFF] ^ byteTable5[crc >>> 16 & 0xFF] ^ byteTable4[crc >>> 24] ^ byteTable3[secondHalf & 0xFF] ^ byteTable2[secondHalf >>> 8 & 0xFF] ^ byteTable1[secondHalf >>> 16 & 0xFF] ^ byteTable0[secondHalf >>> 24] : byteTable0[secondHalf & 0xFF] ^ byteTable1[secondHalf >>> 8 & 0xFF] ^ byteTable2[secondHalf >>> 16 & 0xFF] ^ byteTable3[secondHalf >>> 24] ^ byteTable4[crc & 0xFF] ^ byteTable5[crc >>> 8 & 0xFF] ^ byteTable6[crc >>> 16 & 0xFF] ^ byteTable7[crc >>> 24];
                off += 8;
            }
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                crc = Integer.reverseBytes(crc);
            }
        }
        while (off < end) {
            crc = crc >>> 8 ^ byteTable[(crc ^ b[off]) & 0xFF];
            ++off;
        }
        return crc;
    }

    private static int updateDirectByteBuffer(int crc, ByteBuffer buffer, int off, int end) {
        if (end - off >= 8) {
            int alignLength = 8 - (off & 7) & 7;
            int alignEnd = off + alignLength;
            while (off < alignEnd) {
                crc = crc >>> 8 ^ byteTable[(crc ^ buffer.get(off)) & 0xFF];
                ++off;
            }
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                crc = Integer.reverseBytes(crc);
            }
            while (off <= end - 8) {
                long value = buffer.getLong(off);
                int firstHalf = (int)value;
                int secondHalf = (int)(value >>> 32);
                crc ^= firstHalf;
                crc = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? byteTable7[crc & 0xFF] ^ byteTable6[crc >>> 8 & 0xFF] ^ byteTable5[crc >>> 16 & 0xFF] ^ byteTable4[crc >>> 24] ^ byteTable3[secondHalf & 0xFF] ^ byteTable2[secondHalf >>> 8 & 0xFF] ^ byteTable1[secondHalf >>> 16 & 0xFF] ^ byteTable0[secondHalf >>> 24] : byteTable0[secondHalf & 0xFF] ^ byteTable1[secondHalf >>> 8 & 0xFF] ^ byteTable2[secondHalf >>> 16 & 0xFF] ^ byteTable3[secondHalf >>> 24] ^ byteTable4[crc & 0xFF] ^ byteTable5[crc >>> 8 & 0xFF] ^ byteTable6[crc >>> 16 & 0xFF] ^ byteTable7[crc >>> 24];
                off += 8;
            }
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                crc = Integer.reverseBytes(crc);
            }
        }
        while (off < end) {
            crc = crc >>> 8 ^ byteTable[(crc ^ buffer.get(off)) & 0xFF];
            ++off;
        }
        return crc;
    }

    static {
        int r;
        int index;
        REVERSED_CRC32C_POLY = Integer.reverse(517762881);
        byteTables = new int[8][256];
        byteTable0 = byteTables[0];
        byteTable1 = byteTables[1];
        byteTable2 = byteTables[2];
        byteTable3 = byteTables[3];
        byteTable4 = byteTables[4];
        byteTable5 = byteTables[5];
        byteTable6 = byteTables[6];
        byteTable7 = byteTables[7];
        for (index = 0; index < byteTables[0].length; ++index) {
            r = index;
            for (int i = 0; i < 8; ++i) {
                if ((r & 1) != 0) {
                    r = r >>> 1 ^ REVERSED_CRC32C_POLY;
                    continue;
                }
                r >>>= 1;
            }
            CRC32C.byteTables[0][index] = r;
        }
        for (index = 0; index < byteTables[0].length; ++index) {
            r = byteTables[0][index];
            for (int k = 1; k < byteTables.length; ++k) {
                CRC32C.byteTables[k][index] = r = byteTables[0][r & 0xFF] ^ r >>> 8;
            }
        }
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            byteTable = byteTables[0];
        } else {
            byteTable = new int[byteTable0.length];
            System.arraycopy(byteTable0, 0, byteTable, 0, byteTable0.length);
            for (int[] table : byteTables) {
                for (int index2 = 0; index2 < table.length; ++index2) {
                    table[index2] = Integer.reverseBytes(table[index2]);
                }
            }
        }
    }
}

