/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator.changesets.core;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import liquibase.exception.DatabaseException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.generator.changesets.inerface.ChangeSet;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public abstract class AbstractChangeSet
implements ChangeSet {
    ChangeData _data = new ChangeData();

    protected AbstractChangeSet() throws ObjectNotFoundException, DatabaseException {
        this.cleanDdlParam();
        if (this.isNull(this._data.getOTYPE()) || this.isNull(this._data.getONAME()) || this.isNull(this._data.getDDL())) {
            LbUtils.report(Messages.format(Messages.get("BAD_CL_DATA"), this._data.getOTYPE(), this._data.getONAME(), this._data.getDDL()));
        }
    }

    private boolean isNull(String value) {
        return null == value || value.isEmpty();
    }

    public ChangeData getData() {
        return this._data;
    }

    protected String getGuid() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    protected String getSha1fromString(String data) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(data.getBytes(StandardCharsets.UTF_8));
        return String.format("%040x", new BigInteger(1, digest.digest()));
    }

    private void cleanDdlParam() throws DatabaseException, ObjectNotFoundException {
        Object ddl = this._data.getDDL();
        String oType = this._data.getOTYPE();
        String oName = this._data.getONAME();
        if ((null == ddl || ((String)ddl).isEmpty()) && (null == (ddl = DbmsMetaUtils.getObjectFromDb(LbUtils.getLbConnection().getUnderlyingConnection(), Objects.requireNonNull(oType), Objects.requireNonNull(oName))) || ((String)ddl).isEmpty())) {
            throw new ObjectNotFoundException(Messages.getString("LB_NO_OBJECT"));
        }
        if ("JOB".equalsIgnoreCase(this._data.getOTYPE())) {
            ddl = ((String)ddl).replace("\"", "");
        }
        if ("TRIGGER".equalsIgnoreCase(this._data.getOTYPE())) {
            ddl = ((String)ddl).replace("\n\n/", "\n/");
            String status = DbmsMetaUtils.getTriggerStatus(LbUtils.getLbConnection().getUnderlyingConnection(), oName);
            if ("DISABLED".equalsIgnoreCase(status)) {
                ddl = (String)ddl + "\nALTER TRIGGER " + oName + " DISABLE;";
            } else if ("ENABLED".equalsIgnoreCase(status)) {
                ddl = (String)ddl + "\nALTER TRIGGER " + oName + " ENABLE;";
            }
        }
        this._data.setDDL((String)ddl);
    }
}

