/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Objects;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.generator.AbstractCommonPlSqlGenerator;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunApexScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunInternalScriptStatement;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import org.apache.commons.io.FileUtils;

public class RunInternalScriptGenerator
extends AbstractCommonPlSqlGenerator<AbstractCommonPlSqlStatement> {
    @Override
    public ValidationErrors validate(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors superErrs;
        ValidationErrors errors = new ValidationErrors();
        if (!("STRING".equals(statement.getSourceType()) || "FILE".equals(statement.getSourceType()) || "URL".equals(statement.getSourceType()))) {
            errors.addError("Invalid source type, " + statement.getSourceType() + " is not STRING, FILE or URL");
        }
        if ((superErrs = super.validate(statement, database, chain)).hasErrors()) {
            errors.addAll(superErrs);
        }
        return errors;
    }

    private String processApexScript(String script) {
        String schema = (String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.OVERRIDE_APP_SCHEMA);
        String alias = (String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.OVERRIDE_APP_ALIAS);
        String workspace = (String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.OVERRIDE_APP_WORKSPACE);
        String app_id = (String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.OVERRIDE_APP_ID);
        String source = script;
        source = source.replace("${lb.apex.appId}", Objects.requireNonNullElse(app_id, ""));
        source = source.replace("${lb.apex.schema}", Objects.requireNonNullElse(schema, ""));
        source = source.replace("${lb.apex.alias}", Objects.requireNonNullElse(alias, ""));
        source = source.replace("${lb.apex.workspace}", Objects.requireNonNullElse(workspace, ""));
        return source;
    }

    private String getStringScript(AbstractCommonPlSqlStatement statement) {
        return statement.getSource();
    }

    private String getFileScript(AbstractCommonPlSqlStatement statement) throws LiquibaseException {
        String fileStr = LbFileUtils.getSourceResource(statement);
        File file = Paths.get(fileStr, new String[0]).toFile();
        String script = "";
        if (file.exists()) {
            try {
                script = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new LiquibaseException(fileStr + " not found");
            }
        }
        return script;
    }

    private String getUrlScript(AbstractCommonPlSqlStatement statement) throws LiquibaseException {
        StringBuilder sql = new StringBuilder();
        try {
            URL url = new URL(statement.getSource());
            try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    sql.append(inputLine);
                }
            }
        }
        catch (IOException e) {
            throw new LiquibaseException("Error reading URL script: " + e.getMessage(), (Throwable)e);
        }
        return sql.toString();
    }

    public String getSqlString(AbstractCommonPlSqlChange change) throws LiquibaseException {
        return this.getSqlString(new AbstractCommonPlSqlStatement(change){});
    }

    public String getSqlString(AbstractCommonPlSqlStatement statement) throws LiquibaseException {
        String script = "";
        if ("STRING".equalsIgnoreCase(statement.getSourceType())) {
            script = this.getStringScript(statement);
        } else if ("FILE".equalsIgnoreCase(statement.getSourceType())) {
            script = this.getFileScript(statement);
        } else if ("URL".equalsIgnoreCase(statement.getSourceType())) {
            script = this.getUrlScript(statement);
        }
        if (null != script && !script.isEmpty()) {
            if (statement instanceof RunApexScriptStatement) {
                script = this.processApexScript(script);
            }
            if (script.endsWith("/\n") || script.endsWith("/")) {
                script = script.replaceAll("/\n$", "");
                script = script.replaceAll("/$", "");
            }
        }
        return script;
    }

    @Override
    public AbstractCommonPlSqlGenerator.ACTIONS createOrDrop() {
        return null;
    }

    @Override
    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        try {
            return new Sql[]{new UnparsedSql(this.getSqlString(statement), new DatabaseObject[0])};
        }
        catch (Exception e) {
            return new Sql[0];
        }
    }

    public boolean supports(AbstractCommonPlSqlStatement statement, Database database) {
        return database instanceof OracleDatabase && statement instanceof RunInternalScriptStatement;
    }
}

