/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import oracle.dbtools.extension.MultiCommandSQLCLService;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.SQLCLServices;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class ShowExtensions
extends CommandListener
implements IShowCommand {
    private static final String[] EXTENTIONS = new String[]{"EXTENSIONS", "EXTENSION", "EXTENSIO", "EXTENSI", "EXTENS", "EXTEN", "EXTE", "EXT"};

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return EXTENTIONS;
    }

    private void doShowExtensions(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx == null) {
            return;
        }
        String s = "\nSQLcl Extensions\n----------------------------------------------------------------------------------------------------------------\nName                    Version      Description\n----------------------------------------------------------------------------------------------------------------\n";
        Iterator<SQLCLService> services = SQLCLServices.getInstance().getIterator();
        Iterator<MultiCommandSQLCLService> multiservices = SQLCLServices.getInstance().getMultiIterator();
        ArrayList<SQLCLService> sl = new ArrayList<SQLCLService>();
        while (services.hasNext()) {
            sl.add(services.next());
        }
        while (multiservices.hasNext()) {
            sl.add(multiservices.next());
        }
        if (!sl.isEmpty()) {
            ctx.write(s);
        }
        String s2 = "{0} {1} {2}\n";
        ArrayList<String> feedback = new ArrayList<String>();
        for (SQLCLService service : sl) {
            String next;
            if (service.getExtensionName() == null || feedback.contains((next = MessageFormat.format(s2, this.padRight(service.getExtensionName(), 23), this.padRight(service.getExtensionVersion(), 12), service.getExtensionDescription())).toString())) continue;
            feedback.add(next);
        }
        if (feedback.size() > 0) {
            HashSet set = new HashSet(feedback);
            feedback.clear();
            feedback.addAll(set);
            for (String line : feedback) {
                ctx.write(line);
            }
        }
    }

    public String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        this.doShowExtensions(conn, ctx, cmd);
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

