/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Prompt;
import oracle.dbtools.util.Logger;
import org.fusesource.jansi.Ansi;

public class PromptCmd
extends Prompt {
    static ArrayList<Prompt.IPromptListener> _sqlclListeners = new ArrayList();

    public PromptCmd() {
        PromptCmd.addListener(SQLclPromptListener.getInstance());
    }

    public static void addListener(Prompt.IPromptListener listener) {
        if (!_sqlclListeners.contains(listener)) {
            _sqlclListeners.add(listener);
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        for (Prompt.IPromptListener listener : _sqlclListeners) {
            listener.consume(conn, ctx, cmd);
        }
    }

    public static class SQLclPromptListener
    extends Prompt.DefaultPromptListener {
        static final Prompt.DefaultPromptListener _sqlclInstance = new SQLclPromptListener();

        public static Prompt.IPromptListener getInstance() {
            return _sqlclInstance;
        }

        @Override
        public void consume(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
            String promptMessage = this.getPromptMessage(cmd, ctx);
            String store = "";
            try {
                store = Ansi.ansi().render(promptMessage).reset().toString();
            }
            catch (Exception e) {
                Logger.finest(this.getClass(), "Ansi.ansi().render(promptMessage)" + e.getLocalizedMessage(), e);
                store = promptMessage;
            }
            ctx.write(store);
        }
    }
}

