/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.DefaultFormatter;
import oracle.dbtools.raptor.console.DefaultItemsSelector;
import oracle.dbtools.raptor.console.HighlighterService;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.HistoryService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class HistoryCommand
extends CommandListener
implements IHelp {
    private static final String USAGE = Messages.getString("HistoryCommand.0");
    private static final String TIME = "time";
    private static final String FAILS = "fails";
    private static final String FULL = "full";
    private static final String CLEAR = "clear";
    private static final String SESSION = "session";
    private static final String SCRIPT = "script";
    private static final String REMOVE = "remove";
    private static String SAVE = "save";
    private static String LOAD = "load";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        HistoryService historyService = consoleService.getHistoryService();
        String[] cmds = cmd.getSQLOrig().split("\\s+");
        if (cmds.length > 3) {
            ctx.write(Messages.getString("HistoryCommand.8"));
            ctx.write(Messages.getString("HistoryCommand.9"));
            return true;
        }
        if ((cmd.getSQLOrig().startsWith("his") || cmd.getSQLOrig().startsWith("h")) && cmds.length == 2 | cmds.length == 3) {
            if (cmds[1].toLowerCase().equals(USAGE)) {
                ctx.write(historyService.formatHistory(new DefaultFormatter.Builder().mode(DefaultFormatter.Mode.LIST_OCCURANCES).build()));
                return true;
            }
            if (cmds[1].toLowerCase().equals(FULL)) {
                ctx.write(historyService.formatHistory(new DefaultFormatter.Builder().mode(DefaultFormatter.Mode.LIST_FULL_LINE).build()));
                return true;
            }
            if (cmds[1].toLowerCase().equals(REMOVE)) {
                int i;
                String[] lines = cmds[2].split(",");
                ArrayList<Integer> lint = new ArrayList<Integer>();
                for (i = 0; i < lines.length; ++i) {
                    try {
                        int mint = Integer.parseInt(lines[i]);
                        lint.add(mint);
                        continue;
                    }
                    catch (NumberFormatException mint) {
                        // empty catch block
                    }
                }
                Collections.sort(lint);
                for (i = lint.size(); i >= 0; --i) {
                    if (i > historyService.size() || i < 0) continue;
                    historyService.removeItem(i - 1 + historyService.first());
                }
            } else if (cmds[1].toLowerCase().equals(SCRIPT)) {
                ctx.write(historyService.formatHistory(new DefaultFormatter.Builder().mode(DefaultFormatter.Mode.SCRIPT).build()));
            } else if (cmds[1].toLowerCase().equals(CLEAR)) {
                if (ctx.getProperty("script.runner.jline") != null) {
                    if (cmds.length > 2 && cmds[2].toLowerCase().equals(SESSION)) {
                        historyService.clearCurrentSessionFlags();
                    } else {
                        historyService.purgeHistory();
                    }
                    ctx.write(Messages.getString("HistoryCommand.13"));
                }
            } else {
                if (cmds[1].toLowerCase().equals(SAVE)) {
                    if (ctx.getProperty("script.runner.jline") != null) {
                        historyService.saveHistory();
                    } else {
                        ctx.write(Messages.getString("HistoryCommand.14"));
                    }
                    return true;
                }
                if (cmds[1].toLowerCase().equals(LOAD)) {
                    if (ctx.getProperty("script.runner.jline") != null) {
                        historyService.loadHistory();
                    } else {
                        ctx.write(Messages.getString("HistoryCommand.15"));
                    }
                    return true;
                }
                if (cmds[1].toLowerCase().equals(TIME)) {
                    ctx.write(historyService.formatHistory(new DefaultFormatter.Builder().mode(DefaultFormatter.Mode.LIST_DURATION).build()));
                    return true;
                }
                try {
                    HighlighterService highlighterService = consoleService.getHighlighterService();
                    int a = Integer.parseInt(cmds[1]);
                    List<HistoryItem> historyItems = historyService.selectItems(new DefaultItemsSelector.Builder().build());
                    if (a > 0 && a <= historyItems.size()) {
                        List<String> multiLine = historyItems.get(a - 1).getMultiline();
                        ctx.getSQLPlusBuffer().getBufferSafe().resetBuffer(multiLine);
                        ctx.getSQLPlusBuffer().resetBuffer(multiLine);
                        ctx.write(highlighterService.highlightText(ctx.getSQLPlusBuffer().list(false)));
                        return true;
                    }
                    ctx.write(Messages.getString("HistoryCommand.16"));
                    return false;
                }
                catch (Exception e) {
                    ctx.write(Messages.getString("HistoryCommand.17"));
                }
            }
        } else if ((cmd.getSQLOrig().startsWith("his") || cmd.getSQLOrig().startsWith("h")) && cmds.length == 1) {
            if (historyService.size() > 0) {
                ctx.write("History: \n");
                ctx.write(historyService.formatHistory(new DefaultFormatter.Builder().mode(DefaultFormatter.Mode.LIST_SUMMARY).build()));
            } else {
                ctx.write("History empty\n");
            }
        } else if (cmd.getSQLOrig().startsWith("h") && cmds.length == 1) {
            String item = cmd.getSQLOrig().trim().substring(1);
            int a = Integer.parseInt(item);
            List<HistoryItem> historyItems = historyService.getItems();
            if (a > 0 && a <= historyItems.size()) {
                List<String> multiLine = historyItems.get(a - 1).getMultiline();
                ctx.getSQLPlusBuffer().getBufferSafe().resetBuffer(multiLine);
                ctx.getSQLPlusBuffer().resetBuffer(multiLine);
                ctx.write(ctx.getSQLPlusBuffer().list(false));
                return true;
            }
            ctx.write(Messages.getString("HistoryCommand.21"));
            return false;
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "HISTORY";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }
}

