/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline;

import java.io.File;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionSupport;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.plusplus.connections.db.SqlclConnectionSupport;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.proxy.ProxySelectorImpl;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliGetSpoolFilterProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliHandlePauseProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliHandleSetPauseProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedAcceptProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.scriptrunner.cmdline.handlers.SQLCliPromptedSubstitutionProvider;
import oracle.dbtools.versions.SQLclVersion;

public class SQLCliHelper {
    private static final String DEFAULT_LANG = "en";
    private static final String DEFAULT_COUNTRY = "US";

    private static Locale getLocale() {
        String lang = DEFAULT_LANG;
        String country = DEFAULT_COUNTRY;
        if (System.getProperty("user.language") != null && !System.getProperty("user.language").trim().equals("")) {
            lang = System.getProperty("user.language");
        }
        if (System.getProperty("user.country") != null && !System.getProperty("user.country").trim().equals("")) {
            country = System.getProperty("user.country");
        }
        return new Locale(lang, country);
    }

    public static String getBannerTime() {
        SimpleDateFormat dateformatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", SQLCliHelper.getLocale());
        Calendar now = Calendar.getInstance(SQLCliHelper.getLocale());
        return dateformatter.format((Object)now.getTime());
    }

    public static String getBannerYear() {
        SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy", SQLCliHelper.getLocale());
        Calendar now = Calendar.getInstance(SQLCliHelper.getLocale());
        return yearFormatter.format((Object)now.getTime());
    }

    public static void initCliScriptRunnerContext(ScriptRunnerContext context) {
        context.setVersion(new Version(SQLclVersion.getSQLclVersion()));
        context.setSpoolFilterProvider(new SQLCliGetSpoolFilterProvider());
        context.setPromptedFieldProvider(new SQLCliPromptedAcceptProvider());
        context.setSubstitutionFieldProvider(new SQLCliPromptedSubstitutionProvider());
        context.setPasswordFieldsProvider(new SQLCliPromptedPasswordFieldsProvider());
        context.setConnectFieldsProvider(new SQLCliPromptedConnectFieldsProvider());
        context.setHandlePauseProvider(new SQLCliHandlePauseProvider());
        context.setHandleSetPauseProvider(new SQLCliHandleSetPauseProvider());
        context.setTopLevel(true);
        context.putProperty("script.runner.using.systemout", true);
        context.putProperty("script.runner.arraysize", "15");
        context.putProperty("script.runner.setpagesize", 14);
        context.putProperty("script.runner.setlinesize", 80);
        context.putProperty("script.runner.setlong", 80);
        context.putProperty("script.runner.setlongchunksize", 80);
        context.putProperty("script.runner.setheading", "ON");
        context.putProperty("script.runner.setnumwidth", 10);
        context.putProperty("script.runner.setnumformat", "");
        context.setEncoding(Charset.defaultCharset().displayName());
        context.consumerRuning(true);
        try {
            context.putProperty("script.runner.node.url", new File(System.getProperty("user.dir") + File.separator + "filename_will_be_stripped").toURI().toURL());
        }
        catch (MalformedURLException e) {
            Logger.getLogger("oracle.dbtools").log(Level.SEVERE, e.toString());
            e.printStackTrace();
        }
        context.putProperty("DBConfig.GLOGIN", true);
        ProxySelectorImpl.installProxySelector();
        SqlclConnectionSupport support = new SqlclConnectionSupport();
        ConnectionSupport.setConnectionSupportImplementation(support);
        context.putProperty("cli.conn.resolver", support.getConnectionStoreBridge());
    }

    public static void setDefaultScriptRunnerProperies() {
        ResultSetFormatter.setMaxLines(Integer.MAX_VALUE);
        ResultSetFormatter.setMaxRows(Integer.MAX_VALUE);
    }
}

