/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler.reporting;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import oracle.dbtools.raptor.scheduler.reporting.PathResolver;
import oracle.dbtools.raptor.scheduler.reporting.ReportLine;

public class Reporter {
    private final PathResolver pathResolver;

    public Reporter() {
        this(new PathResolver());
    }

    public Reporter(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public void reportFoJob(String jobName, ReportLine reportLine) throws UncheckedIOException {
        this.write(this.pathResolver.getJobPath(jobName), reportLine.format());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Path filePath, String content) throws UncheckedIOException {
        Reporter reporter = this;
        synchronized (reporter) {
            try {
                if (Files.notExists(filePath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
                if (Files.notExists(filePath, new LinkOption[0])) {
                    Files.createFile(filePath, new FileAttribute[0]);
                }
                Files.write(filePath, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void reportForAllJobs(ReportLine reportLine) throws UncheckedIOException {
        this.write(this.pathResolver.getAllJobsPath(), reportLine.format());
    }

    public void reportForScheduler(ReportLine reportLine) throws UncheckedIOException {
        this.write(this.pathResolver.getSchedulerPath(), reportLine.format());
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }
}

