/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler.reporting;

import oracle.dbtools.raptor.scheduler.SchedulerMessages;
import oracle.dbtools.raptor.scheduler.job.Job;
import oracle.dbtools.raptor.scheduler.reporting.ReportLine;
import oracle.dbtools.raptor.scheduler.reporting.Reporter;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;

public class JobsListener
extends JobListenerSupport {
    private final Reporter reporter;

    public JobsListener(Reporter reporter) {
        this.reporter = reporter;
    }

    public String getName() {
        return "JobsListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        Job job = (Job)context.getJobDetail().getJobDataMap().get((Object)"job");
        this.reporter.reportFoJob(job.getName(), ReportLine.ofNow(JobStatus.RUNNING, ReportLine.Token.message(SchedulerMessages.getString("JOB_EXECUTION_STARTED"))));
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Job job = (Job)context.getJobDetail().getJobDataMap().get((Object)"job");
        if (jobException != null) {
            Throwable cause = this.getCauseException((Throwable)jobException);
            this.reporter.reportFoJob(job.getName(), ReportLine.ofNow(JobStatus.FAILED, ReportLine.Token.error(cause.getMessage())));
        } else {
            Object result = context.getResult();
            String output = result != null ? (String)result : SchedulerMessages.getString("NO_JOB_RESULT_RETURNED");
            this.reporter.reportFoJob(job.getName(), ReportLine.ofNow(JobStatus.COMPLETED, ReportLine.ResultToken.of(output)));
        }
    }

    private Throwable getCauseException(Throwable t) {
        Throwable cause;
        for (cause = t; cause != null && cause.getCause() != null; cause = cause.getCause()) {
        }
        return cause;
    }

    private static enum JobStatus implements ReportLine.Status
    {
        RUNNING,
        FAILED,
        COMPLETED;

    }
}

