/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scheduler;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scheduler.SchedulerFile;
import oracle.dbtools.raptor.scheduler.SchedulerMessages;
import oracle.dbtools.raptor.scheduler.SqlclCommandJob;
import oracle.dbtools.raptor.scheduler.exceptions.SqlclSchedulerException;
import oracle.dbtools.raptor.scheduler.job.Job;
import oracle.dbtools.raptor.scheduler.reporting.JobsListener;
import oracle.dbtools.raptor.scheduler.reporting.ReportLine;
import oracle.dbtools.raptor.scheduler.reporting.Reporter;
import oracle.dbtools.raptor.scheduler.reporting.SqlclSchedulerListener;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class SqlclScheduler {
    private final SchedulerFile schedulerFile;
    private final Scheduler scheduler;
    private final Reporter reporter;
    private final Map<String, JobKey> scheduledJobs = new ConcurrentHashMap<String, JobKey>();

    public SqlclScheduler() throws SqlclSchedulerException {
        this(new SchedulerFile());
    }

    public SqlclScheduler(SchedulerFile schedulerFile) throws SqlclSchedulerException {
        this(schedulerFile, new Reporter());
    }

    SqlclScheduler(SchedulerFile schedulerFile, Reporter reporter) throws SqlclSchedulerException {
        try {
            this.schedulerFile = schedulerFile;
            this.reporter = reporter;
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.getListenerManager().addSchedulerListener((SchedulerListener)new SqlclSchedulerListener(reporter));
            this.scheduler.getListenerManager().addJobListener((JobListener)new JobsListener(reporter));
        }
        catch (SchedulerException e) {
            throw new SqlclSchedulerException(e);
        }
    }

    public void start() throws SqlclSchedulerException {
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            this.reporter.reportForAllJobs(ReportLine.ofNow(SqlclSchedulerStatus.STARTUP_FAILED, ReportLine.Token.error(e.getMessage())));
            throw new SqlclSchedulerException(e);
        }
    }

    public void scheduleJobs(ScriptRunnerContext context) {
        try {
            List<Job> jobs = this.schedulerFile.loadJobs();
            if (jobs.isEmpty()) {
                throw new SchedulerException(SchedulerMessages.format("NO_JOBS_FOUND", this.schedulerFile.getFilePath()));
            }
            HashSet<String> newJobChecksums = new HashSet<String>();
            for (Job job : jobs) {
                String checksum = this.computeChecksum(job);
                newJobChecksums.add(checksum);
                if (this.scheduledJobs.containsKey(checksum)) {
                    String jobLogFilePath = this.reporter.getPathResolver().getJobPath(job.getName()).toString();
                    this.reporter.reportForAllJobs(ReportLine.ofNow(SqlclSchedulerStatus.SCHEDULE_JOB, ReportLine.Token.of("JOB", job.getName()), ReportLine.Token.of("JOB_LOG", jobLogFilePath)));
                    continue;
                }
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("job", (Object)job);
                jobDataMap.put("runner", (Object)context);
                JobDetail jobDetail = JobBuilder.newJob(SqlclCommandJob.class).withIdentity(checksum, System.getProperty("user.name")).usingJobData(jobDataMap).build();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger_" + checksum, System.getProperty("user.name")).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getCron())).usingJobData(jobDataMap).build();
                this.scheduler.scheduleJob(jobDetail, trigger);
                this.scheduledJobs.put(checksum, jobDetail.getKey());
            }
            HashSet<String> checksumsToRemove = new HashSet<String>(this.scheduledJobs.keySet());
            checksumsToRemove.removeAll(newJobChecksums);
            for (String checksum : checksumsToRemove) {
                JobKey jobKey = this.scheduledJobs.get(checksum);
                this.scheduler.deleteJob(jobKey);
                this.scheduledJobs.remove(checksum);
            }
        }
        catch (RuntimeException | NoSuchAlgorithmException | SchedulerException e) {
            this.reporter.reportForAllJobs(ReportLine.ofNow(SqlclSchedulerStatus.JOB_SCHEDULE_FAILED, ReportLine.Token.error(e.getMessage())));
        }
    }

    private String computeChecksum(Job job) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(job.toString().getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public void shutdown() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            this.reporter.reportForAllJobs(ReportLine.ofNow(SqlclSchedulerStatus.SHUTDOWN_FAILED, ReportLine.Token.error(e.getMessage())));
            throw new SqlclSchedulerException(e);
        }
    }

    public SchedulerFile getSchedulerFile() {
        return this.schedulerFile;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }

    public static enum SqlclSchedulerStatus implements ReportLine.Status
    {
        JOB_SCHEDULE_FAILED,
        SCHEDULE_JOB,
        STARTED,
        STARTUP_FAILED,
        STOPPED,
        SHUTDOWN_FAILED;

    }
}

