/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.util.Map;
import oracle.dbtools.raptor.console.StatusBarComponent;
import oracle.dbtools.raptor.console.impl.SqlclConsole;
import org.fusesource.jansi.Ansi;
import org.jline.keymap.KeyMap;
import org.jline.reader.Buffer;
import org.jline.reader.LineReader;
import org.jline.reader.Reference;
import org.jline.reader.Widget;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Cursor;
import org.jline.terminal.Terminal;
import org.jline.utils.Status;
import org.jline.widget.Widgets;

public class SqlclWidgets
extends Widgets {
    public static final String CANCEL_EDIT = "cl-cancel-edit";
    public static final String BEGINNING_OF_BUFFER = "cl-beginning-of-buffer";
    public static final String END_OF_BUFFER = "cl-end-of-buffer";
    public static final String RUN_IMMEDIATELY = "cl-run-immediately";
    public static final String REDRAW_DISPLAY = "cl-redraw-display";
    public static final String COLLECT_GARBAGE = "cl-collect-garbage";
    public static final String END_PASTE = "cl-end-paste";
    public static final String NULL_WIDGET = "cl-null-widget";
    private final SqlclConsole console;
    private final Buffer buffer;
    private boolean runImmediately = false;
    private long lastKeyStrokeMillis = 0L;

    public SqlclWidgets(SqlclConsole console, LineReaderImpl reader) {
        super((LineReader)reader);
        this.console = console;
        this.buffer = reader.getBuffer();
        this.addAnyWidget("clear-screen", () -> console.clearScreen());
        this.addAnyWidget(REDRAW_DISPLAY, () -> reader.redrawDisplay());
        this.addAnyWidget("callback-init", () -> this.callbackInit());
        this.addAnyWidget("accept-line", () -> this.acceptLine());
        this.addAnyWidget("abort", () -> this.signalInterrupt());
        this.addAnyWidget(BEGINNING_OF_BUFFER, () -> this.beginningOfBuffer());
        this.addAnyWidget(END_OF_BUFFER, () -> this.endOfBuffer());
        this.addAnyWidget(CANCEL_EDIT, () -> this.endOfBuffer());
        this.addAnyWidget(COLLECT_GARBAGE, () -> this.collectGarbage());
        this.addUpWidget("up-line-or-search");
        this.addUpWidget("up-line-or-history");
        this.addUpWidget("vi-up-line-or-history");
        this.addDownWidget("down-line-or-search");
        this.addDownWidget("down-line-or-history");
        this.addDownWidget("vi-down-line-or-history");
        this.addRunImmediatelyWidget(RUN_IMMEDIATELY);
        this.addDeleteLinesWidget("backward-delete-char");
        this.addDeleteLinesWidget("delete-char");
        this.addDeleteLinesWidget("backward-kill-word");
        this.addDeleteLinesWidget("delete-char-or-list");
        this.addDeleteLinesWidget("kill-buffer");
        this.addDeleteLinesWidget("kill-line");
        this.addDeleteLinesWidget("kill-region");
        this.addDeleteLinesWidget("kill-whole-line");
        this.addDeleteLinesWidget("kill-word");
        this.addDeleteLinesWidget("vi-delete");
        this.addDeleteLinesWidget("vi-backward-delete-char");
        this.addDeleteLinesWidget("vi-delete-char");
        this.addDeleteLinesWidget("vi-kill-line");
        this.addDeleteLinesWidget("vi-replace-chars");
        this.bind("emacs", "clear-screen", KeyMap.ctrl((char)'L'));
        this.bind("viins", "emacs-editing-mode", KeyMap.ctrl((char)'E'));
        this.bind("visual", "kill-region", "d");
        this.bind("emacs", CANCEL_EDIT, KeyMap.ctrl((char)'\\'));
        this.bind("vicmd", CANCEL_EDIT, KeyMap.ctrl((char)'\\'));
        this.bind("viins", CANCEL_EDIT, KeyMap.ctrl((char)'\\'));
        this.bind("emacs", CANCEL_EDIT, KeyMap.esc());
        this.bind("vicmd", CANCEL_EDIT, KeyMap.esc());
        this.bind("emacs", BEGINNING_OF_BUFFER, KeyMap.alt((char)'a'));
        this.bind("vicmd", BEGINNING_OF_BUFFER, KeyMap.alt((char)'a'));
        this.bind("viins", BEGINNING_OF_BUFFER, KeyMap.alt((char)'a'));
        this.bind("emacs", END_OF_BUFFER, KeyMap.alt((char)'e'));
        this.bind("vicmd", END_OF_BUFFER, KeyMap.alt((char)'e'));
        this.bind("viins", END_OF_BUFFER, KeyMap.alt((char)'e'));
        this.bind("emacs", RUN_IMMEDIATELY, KeyMap.ctrl((char)'R'));
        this.bind("vicmd", RUN_IMMEDIATELY, KeyMap.ctrl((char)'R'));
        this.bind("viins", RUN_IMMEDIATELY, KeyMap.ctrl((char)'R'));
        try {
            LineReaderImpl.class.getDeclaredMethod("redrawDisplay", new Class[0]);
            this.bind("emacs", REDRAW_DISPLAY, KeyMap.alt((char)'!'));
            this.bind("vicmd", REDRAW_DISPLAY, KeyMap.alt((char)'!'));
            this.bind("viins", REDRAW_DISPLAY, KeyMap.alt((char)'!'));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.bind("emacs", COLLECT_GARBAGE, KeyMap.alt((char)'g'));
        this.bind("vicmd", COLLECT_GARBAGE, KeyMap.alt((char)'g'));
        this.bind("viins", COLLECT_GARBAGE, KeyMap.alt((char)'g'));
        this.bind("emacs", END_PASTE, "\u001b[201~");
        this.bind("viins", END_PASTE, "\u001b[201~");
        this.bind("vicmd", END_PASTE, "\u001b[201~");
        this.unbind("visual", "x");
        this.nullWidget("edit-and-execute-command");
        this.nullWidget("infer-next-history");
        this.nullWidget("history-incremental-search-backward");
        this.nullWidget("history-incremental-search-forward");
        this.nullWidget("history-search-backward");
        this.nullWidget("history-search-forward");
        this.nullWidget("vi-history-search-backward");
        this.nullWidget("vi-history-search-forward");
        this.nullWidget("vi-repeat-search");
        this.nullWidget("vi-rev-repeat-search");
        this.nullWidget("vi-fetch-history");
        this.nullWidget("character-search");
        this.nullWidget("character-search-backward");
        this.nullWidget("accept-and-hold");
        this.nullWidget("reverse-menu-complete");
        this.nullWidget("put-replace-selection");
        this.nullWidget("vi-replace");
        this.nullWidget("vi-substitute");
        this.nullWidget("vi-insert-comment");
        this.nullWidget("vi-digit-or-beginning-of-line");
        this.nullWidget("vi-repeat-change");
        this.nullWidget("vi-oper-swap-case");
        this.nullWidget("begin-paste");
        this.nullWidget(END_PASTE);
        this.nullWidget(NULL_WIDGET);
        this.nullifyEscBindings("emacs");
        this.nullifyEscBindings("vicmd");
        this.nullifyEscBindings("viins");
        this.nullifyEscBindings("visual");
        this.addKeyStrokeMonitors();
    }

    public boolean isEditing() {
        return this.buffer.cursor() < this.buffer.length();
    }

    public boolean isRunImmediately() {
        return this.runImmediately;
    }

    public boolean onUp(String widget) {
        if (this.isEditing() && !this.atTopRow()) {
            this.callWidget("up-line");
        } else {
            this.callWidget("up-history");
        }
        return true;
    }

    public boolean onDown(String widget) {
        if (this.isEditing() && !this.atBottomRow()) {
            this.callWidget("down-line");
        } else {
            this.callWidget("down-history");
        }
        return true;
    }

    public boolean onDeleteLines(String widget) {
        int rows = this.getRowsInBuffer();
        this.callWidget(widget);
        if (this.isEditing() && rows >= this.reader.getTerminal().getHeight()) {
            int newRows = this.getRowsInBuffer();
            if (rows > 0 && newRows < rows) {
                this.reader().clearScreen();
            }
        }
        return true;
    }

    public boolean onRunImmediately(String widg) {
        this.runImmediately = true;
        this.callWidget("accept-line");
        return true;
    }

    public boolean callbackInit() {
        if (this.console.system()) {
            StringBuilder tsb = new StringBuilder();
            Terminal terminal = this.reader.getTerminal();
            Cursor cursor = terminal.getCursorPosition(c -> tsb.append((char)c));
            this.reader.runMacro(tsb.toString());
            int portHeight = terminal.getHeight() - Status.getStatus((Terminal)terminal).size();
            if (cursor.getY() >= portHeight) {
                terminal.writer().write(Ansi.ansi().cursor(portHeight, cursor.getX()).toString());
            }
        }
        this.console.getStatusBarService().refresh(StatusBarComponent.Reason.READ_INIT, true);
        return true;
    }

    public boolean acceptLine() {
        if (this.isEditing() && !this.atBufferEnd(0)) {
            this.buffer().write(10);
        } else {
            this.callWidget("accept-line");
        }
        return true;
    }

    public void onLineAccepted() {
        this.runImmediately = false;
    }

    public boolean beginningOfBuffer() {
        this.goToBufferStart();
        return true;
    }

    public boolean endOfBuffer() {
        this.goToBufferEnd();
        return true;
    }

    public boolean collectGarbage() {
        System.gc();
        return true;
    }

    private int getRowsInBuffer() {
        int numRows = 1;
        String buf = this.buffer().toString();
        int length = buf.length();
        for (int c = 0; c < length; ++c) {
            if (buf.charAt(c) != '\n') continue;
            ++numRows;
        }
        return numRows;
    }

    private boolean atTopRow() {
        boolean atTopRow = true;
        int cursor = this.buffer().cursor();
        for (int c = 0; c < cursor; ++c) {
            if (this.buffer().atChar(c) != 10) continue;
            atTopRow = false;
            break;
        }
        return atTopRow;
    }

    private boolean atBottomRow() {
        int length;
        boolean atBottomRow = true;
        int cursor = this.buffer().cursor();
        for (int c = length = this.buffer().length(); c > cursor; --c) {
            if (this.buffer().atChar(c) != 10) continue;
            atBottomRow = false;
            break;
        }
        return atBottomRow;
    }

    private void goToBufferStart() {
        while (!this.atTopRow()) {
            this.buffer().up();
            this.reader().redisplay();
        }
        this.buffer().cursor(0);
    }

    private void goToBufferEnd() {
        while (!this.atBottomRow()) {
            this.buffer().down();
            this.reader().redisplay();
        }
        this.buffer().cursor(this.buffer().length());
    }

    private boolean atBufferEnd(int offsetFromCursor) {
        int cursor = this.buffer().cursor();
        String tail = this.buffer().substring(cursor + offsetFromCursor).trim();
        return tail.isEmpty();
    }

    private void addKeyStrokeMonitors() {
        Map widgetMap = this.reader.getWidgets();
        for (String name : widgetMap.keySet()) {
            Widget widget = (Widget)widgetMap.get(name);
            widgetMap.put(name, () -> {
                boolean result = widget.apply();
                long newKeyStrokeMillis = System.currentTimeMillis();
                if (newKeyStrokeMillis - this.lastKeyStrokeMillis > 200L) {
                    this.console.getStatusBarService().refresh(StatusBarComponent.Reason.KEY_STROKE, true);
                    this.lastKeyStrokeMillis = newKeyStrokeMillis;
                }
                return result;
            });
        }
    }

    private void addAnyWidget(String name, Widget widget) {
        super.addWidget(name, widget);
    }

    private void addUpWidget(String widget) {
        this.addWidget(widget, () -> this.onUp(widget));
    }

    private void addDownWidget(String widget) {
        this.addWidget(widget, () -> this.onDown(widget));
    }

    private void addDeleteLinesWidget(String widget) {
        this.addWidget(widget, () -> this.onDeleteLines(widget));
    }

    private void addRunImmediatelyWidget(String widget) {
        this.addWidget(widget, () -> this.onRunImmediately(widget));
    }

    private void bind(String keyMap, String name, CharSequence keySeq) {
        ((KeyMap)this.reader.getKeyMaps().get(keyMap)).bind((Object)new Reference(name), keySeq);
    }

    private void unbind(String keyMap, CharSequence keySeq) {
        ((KeyMap)this.reader.getKeyMaps().get(keyMap)).unbind(keySeq);
    }

    private void nullWidget(String widget) {
        this.addWidget(widget, () -> true);
    }

    private void nullifyEscBindings(String keyMapName) {
        KeyMap keyMap = (KeyMap)this.reader.getKeyMaps().get(keyMapName);
        for (int c = 0; c < 128; ++c) {
            keyMap.bindIfNotBound((Object)new Reference(NULL_WIDGET), (CharSequence)KeyMap.alt((char)((char)c)));
        }
    }

    private boolean signalInterrupt() {
        this.reader.getTerminal().raise(Terminal.Signal.INT);
        return true;
    }

    private LineReaderImpl reader() {
        return (LineReaderImpl)this.reader;
    }
}

