/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.util.Logger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HistoryLogs {
    public void migrate(Path path) throws IOException {
        Path fromPath;
        if (!Files.exists(path, new LinkOption[0]) && Files.exists(fromPath = Paths.get(System.getProperty("user.home"), ".sqlplus", "history.xml"), new LinkOption[0])) {
            this.doMigrate(fromPath, path);
        }
    }

    public void read(Path path, LogConsumer logConsumer) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                reader.lines().forEach(logEntry -> this.decode((String)logEntry, logConsumer));
            }
        }
    }

    public void write(Path path, Iterator<LogRow> logRowIterator) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                Logger.log(this.getClass(), Level.FINE, "unable to create history log file", ex);
            }
        }
        if (Files.isWritable(path)) {
            try (BufferedWriter writer = FileUtils.openSecureFile(path.toAbsolutePath(), Set.of(StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE));){
                while (logRowIterator.hasNext()) {
                    LogRow logRow = logRowIterator.next();
                    writer.write(this.encode(logRow) + "\n");
                }
            }
        }
    }

    private void decode(String logEntry, LogConsumer logConsumer) {
        LogRowStatus status;
        String[] tokens = logEntry.split(":", 5);
        if (tokens.length != 5) {
            return;
        }
        UUID uuid = UUID.fromString(tokens[0]);
        long timeMillis = tokens[1].isEmpty() ? -1L : Long.parseLong(tokens[1]);
        long durationMillis = Long.parseLong(tokens[2]);
        switch (tokens[3]) {
            case "S": {
                status = LogRowStatus.SUCCEEDED;
                break;
            }
            case "R": {
                status = LogRowStatus.REMOVED;
                break;
            }
            default: {
                status = LogRowStatus.FAILED;
            }
        }
        String line = this.unescape(tokens[4]);
        logConsumer.consume(this.createLogRow(uuid, timeMillis, durationMillis, status, line));
    }

    private String encode(LogRow logRow) {
        char statusCode;
        StringBuilder buffer = new StringBuilder();
        buffer.append(logRow.uuid().toString());
        buffer.append(':');
        if (logRow.timeMillis() >= 0L) {
            buffer.append(Long.toString(logRow.timeMillis()));
        }
        buffer.append(':');
        buffer.append(Long.toString(logRow.durationMillis()));
        buffer.append(':');
        switch (logRow.status().ordinal()) {
            case 0: {
                statusCode = 'S';
                break;
            }
            case 2: {
                statusCode = 'R';
                break;
            }
            default: {
                statusCode = 'F';
            }
        }
        buffer.append(statusCode);
        buffer.append(':');
        buffer.append(this.escape(logRow.line()));
        return buffer.toString();
    }

    private String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block5;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block5;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private String unescape(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    ch = s.charAt(++i);
                    switch (ch) {
                        case 'n': {
                            sb.append('\n');
                            continue block7;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block7;
                        }
                    }
                    sb.append(ch);
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private void doMigrate(Path fromPath, Path toPath) throws IOException {
        try (FileWriter fileWriter = new FileWriter(toPath.toFile());){
            try (FileReader fileReader = new FileReader(fromPath.toFile());){
                DOMParser parser = new DOMParser();
                parser.setPreserveWhitespace(false);
                try {
                    parser.parse((Reader)fileReader);
                }
                catch (SAXException ex) {
                    throw new IOException(ex);
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM y-h.m");
                XMLDocument document = parser.getDocument();
                NodeList rootNodes = document.getChildNodes();
                for (int n = 0; n < rootNodes.getLength(); ++n) {
                    Node item = rootNodes.item(n);
                    NodeList children = item.getChildNodes();
                    for (int c = 0; c < children.getLength(); ++c) {
                        Node child = children.item(c);
                        String childName = child.getNodeName();
                        if (!childName.equalsIgnoreCase("historyItem")) continue;
                        this.logFileEntryFromXMLNode(fileWriter, child, dateFormat);
                    }
                }
            }
            ((Writer)fileWriter).flush();
        }
    }

    private void logFileEntryFromXMLNode(Writer writer, Node child, DateFormat dateFormat) throws IOException {
        String line = "";
        long timeMillis = 0L;
        long durationMillis = 0L;
        boolean failed = false;
        NodeList nodeList = child.getChildNodes();
        block14: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeName()) {
                case "original": {
                    line = this.getTextFromXMLNode(node);
                    continue block14;
                }
                case "timestamp": {
                    timeMillis = this.getMillisFromTimeStamp(this.getTextFromXMLNode(node), dateFormat);
                    continue block14;
                }
                case "timesUsed": {
                    continue block14;
                }
                case "timing": {
                    durationMillis = Long.parseLong(this.getTextFromXMLNode(node));
                    continue block14;
                }
                case "failure": {
                    failed = Boolean.parseBoolean(this.getTextFromXMLNode(node));
                }
            }
        }
        LogRow logRow = this.createLogRow(UUID.randomUUID(), timeMillis, durationMillis, failed ? LogRowStatus.FAILED : LogRowStatus.SUCCEEDED, line);
        writer.write(this.encode(logRow) + "\n");
    }

    private long getMillisFromTimeStamp(String timeStamp, DateFormat dateFormat) {
        Instant instant;
        try {
            instant = dateFormat.parse(timeStamp).toInstant();
        }
        catch (ParseException ex) {
            instant = Instant.now();
        }
        return instant.toEpochMilli();
    }

    private String getTextFromXMLNode(Node node) {
        Node n1 = node.getFirstChild();
        String text = null;
        if (n1 instanceof Text) {
            text = ((Text)n1).getTextContent();
        }
        return text;
    }

    private LogRow createLogRow(final UUID uuid, final long timeMillis, final long durationMillis, final LogRowStatus status, final String line) {
        return new LogRow(){

            @Override
            public UUID uuid() {
                return uuid;
            }

            @Override
            public long timeMillis() {
                return timeMillis;
            }

            @Override
            public long durationMillis() {
                return durationMillis;
            }

            @Override
            public LogRowStatus status() {
                return status;
            }

            @Override
            public String line() {
                return line;
            }
        };
    }

    public static interface LogConsumer {
        public void consume(LogRow var1);
    }

    public static interface LogRow {
        public UUID uuid();

        public long timeMillis();

        public long durationMillis();

        public LogRowStatus status();

        public String line();
    }

    public static enum LogRowStatus {
        SUCCEEDED,
        FAILED,
        REMOVED;

    }
}

