/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.util.ServiceLoader;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;

public interface ConnectionsConverterFactory {
    public static final ConnectionsConverterFactory NULL_FACTORY = new ConnectionsConverterFactory(){

        @Override
        public boolean canConvert(DatabaseProvider provider) {
            return false;
        }

        @Override
        public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging, Connections.Identifier identifier) {
            return null;
        }
    };
    public static final ServiceLoader<ConnectionsConverterFactory> LOADER = ServiceLoader.load(ConnectionsConverterFactory.class);

    public boolean canConvert(DatabaseProvider var1);

    public ConnectionsConverter createConverter(DatabaseProvider var1, MessageLogger var2, Connections.Identifier var3);

    default public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging) {
        return this.createConverter(provider, logging, null);
    }

    public static ConnectionsConverter getConverter(DatabaseProvider provider, MessageLogger logging, Connections.Identifier identifier) {
        ConnectionsConverter converter = null;
        for (ConnectionsConverterFactory factory : LOADER) {
            if (!factory.canConvert(provider)) continue;
            converter = factory.createConverter(provider, logging, identifier);
            break;
        }
        if (converter == null) {
            converter = NULL_FACTORY.createConverter(provider, logging);
        }
        return converter;
    }
}

