/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.helpers.ora.Constants;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.storage.StoreException;
import oracle.dbtools.core.connections.storage.UnicodeSafeWalletSecrets;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.util.InputOutputStreams;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public abstract class ConnectionsConverter
implements Constants {
    public static final String SQLDEV_ADVANCED_PREFIX = "sqldev.advanced.";
    protected final Connections.Identifier identifier;
    protected final DatabaseProvider definition;
    protected final MessageLogger logger;
    private final ConfigurationProperties.Builder dbToolsProperties = ConfigurationProperties.builder();
    private final ConfigurationProperties.Builder advancedProperties = ConfigurationProperties.builder();
    private TextSecret password;

    protected ConnectionsConverter(DatabaseProvider provider, MessageLogger logger) {
        this(provider, logger, null);
    }

    protected ConnectionsConverter(DatabaseProvider provider, MessageLogger logger, Connections.Identifier identifier) {
        this.definition = provider;
        this.logger = logger;
        this.identifier = identifier != null ? identifier : ConnectionIdentifiers.createUniqueIdentifier();
        this.password = TextSecret.none();
    }

    public abstract ImportedConnectionResult convert() throws IOException;

    protected void processCredentials(String spec) throws IOException {
        String username = this.definition.getProperty("user");
        String pwd = this.definition.getProperty("password");
        String role = this.definition.getProperty("role");
        this.processCredentials(spec, username, pwd, role);
    }

    protected void processCredentials(String spec, String username, String pwd, String role) {
        this.addDBToolsProperty("userName", username);
        if (ModelUtil.hasLength(username) && ModelUtil.hasLength(pwd)) {
            this.addCredentials(spec, username, pwd.toCharArray());
        }
        if (ModelUtil.hasLength(role)) {
            this.setRole(role);
        }
    }

    protected void copyValue(String key) {
        String value = this.definition.getProperty(key);
        this.addDBToolsProperty(key, value);
    }

    protected final String processDisplayName() {
        String displayName = this.definition.getName();
        this.addDBToolsProperty("name", displayName);
        return displayName;
    }

    private OracleWallet newWallet() throws IOException {
        OracleWallet wallet = new OracleWallet();
        wallet.createSSO();
        return wallet;
    }

    protected void output(ConnectionStorage store) throws IOException {
        ConnectionDefinition.Builder builder = ConnectionDefinition.builder((Connections.Identifier)this.identifier);
        if (!this.advancedProperties.isEmpty()) {
            builder.ojdbcProperties(this.advancedProperties.build());
        }
        if (!this.dbToolsProperties.isEmpty()) {
            builder.dbtoolsProperties(this.dbToolsProperties.build());
        }
        if (this.password.isPresent()) {
            OracleWallet wallet = this.newWallet();
            this.updateWallet(wallet);
            builder.wallet(wallet);
        }
        ConnectionDefinition definition = builder.build();
        store.storeDefinition(definition);
    }

    protected final void writeWallet(ConnectionStorage store, Connections.Identifier identifier) throws IOException {
        if (this.password.isPresent()) {
            OracleWallet wallet = this.newWallet();
            this.updateWallet(wallet);
            store.storeObject(identifier, "credentials.sso", (Object)wallet, (data, out) -> {
                try (InputStream is = data.getWalletArray(true);){
                    InputOutputStreams.instance().copy(is, out);
                }
            });
        }
    }

    protected final void writeAdvancedProperties(ConnectionStorage store, Connections.Identifier identifier) throws StoreException {
        store.storeObject(identifier, "ojdbc.properties", (Object)this.advancedProperties.build(), ConnectionDefinition::outputProperties);
    }

    protected final void writeDBToolsProperties(ConnectionStorage store, Connections.Identifier identifier) throws StoreException {
        store.storeObject(identifier, "dbtools.properties", (Object)this.dbToolsProperties.build(), ConnectionDefinition::outputProperties);
    }

    protected void outputAdvancedProperties(OutputStream out) throws IOException {
        ConnectionDefinition.outputProperties((ConfigurationProperties)this.advancedProperties.build(), (OutputStream)out);
    }

    protected void outputDBToolsProperties(OutputStream out) throws IOException {
        ConnectionDefinition.outputProperties((ConfigurationProperties)this.dbToolsProperties.build(), (OutputStream)out);
    }

    protected void updateWallet(OracleWallet wallet) throws IOException {
        if (this.password.isPresent()) {
            try {
                OracleSecretStore store = wallet.getSecretStore();
                UnicodeSafeWalletSecrets secrets = UnicodeSafeWalletSecrets.of((OracleSecretStore)store);
                secrets.write((CharSequence)"dbtools.database.password.base64", this.password);
                wallet.setSecretStore(store);
            }
            catch (OracleSecretStoreException e) {
                throw new IOException(e);
            }
        }
    }

    protected final void addDBToolsProperty(String key, String value) {
        if (value != null) {
            this.dbToolsProperties.put(key, value);
        }
    }

    protected final void addAdvancedProperty(String key, String value) {
        if (value != null) {
            this.advancedProperties.put(key, value);
        }
    }

    protected final void setRole(String role) {
        if (role != null) {
            this.addAdvancedProperty("internal_logon", role);
        }
    }

    protected final void addCredentials(String key, String user, char[] pwd) {
        this.password = Secrets.instance().of(pwd, true);
    }
}

