/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import oracle.dbtools.core.connections.helpers.ConnectCredentials;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ConnectionTester {
    private static final String TEST_QUERY = "select banner from v$version";
    private final ConnectionHelper creator;
    private final ScriptRunnerContext ctx;
    private final MessageLogger logger;

    public static Builder builder(ConnectionDefinition definition) {
        return new Builder().connectionDefinition(definition);
    }

    private ConnectionTester(Builder builder) {
        this.creator = ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)builder.definition, (MessageLogger)builder.logger));
        this.ctx = builder.ctx;
        this.logger = builder.logger;
    }

    public void testConnection(String user) throws SQLException {
        ConnectionDetails cd;
        String connSpec = this.creator.getConnectionSpec();
        if (user != null) {
            cd = new ConnectionDetails(connSpec, false, user, null, connSpec, null, false, -1, -1, null);
        } else {
            String storedUser = this.creator.getUsername();
            TextSecret storedPwd = this.creator.getPassword();
            cd = new ConnectionDetails(connSpec, false, storedUser, storedPwd, connSpec, null, false, -1, -1, null);
        }
        ConnectionDetails updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false);
        if (updatedDetails != null) {
            ConnectCredentials creds = ConnectCredentials.of((String)updatedDetails.getConnectName(), (TextSecret)updatedDetails.getConnectPassword(), (String)updatedDetails.getRole());
            try (Connection conn = this.creator.createConnection(creds, new Properties());
                 Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(TEST_QUERY);){
                if (rs.next()) {
                    this.logger.logUserMessage(rs.getString(1));
                }
            }
        }
    }

    public static class Builder {
        private ConnectionDefinition definition;
        private ScriptRunnerContext ctx;
        private MessageLogger logger;

        public Builder connectionDefinition(ConnectionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder scriptRunnerContext(ScriptRunnerContext ctx) {
            this.ctx = ctx;
            return this;
        }

        public Builder messageLogger(MessageLogger logger) {
            this.logger = logger;
            return this;
        }

        public ConnectionTester build() {
            return new ConnectionTester(this);
        }
    }
}

