/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.Substr;

public class HarvestDoc {
    public static final String common = "common/";
    private static final String templatesFN = "templates.txt";
    private static final String frequenciesFN = "frequencies.txt";
    private static final String railroadsFN = "railroad.txt";
    static final String path = "/oracle/dbtools/parser/plsql/doc/";
    private static Map<Long, Set<Substr>> templates = new HashMap<Long, Set<Substr>>();
    private static Map<Long, Integer> frequencies = null;
    private static Map<Integer, DocURL> railroads = new HashMap<Integer, DocURL>();

    public static Map<Long, Set<Substr>> getTemplates() {
        if (templates.size() == 0) {
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/templates.txt");
            try {
                InputStream is = u.openStream();
                StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n", true);
                int pos = 0;
                HashMap<Integer, String> refs = new HashMap<Integer, String>();
                StringBuilder sb = new StringBuilder();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ((token = token.replace("\r", "")).equals("===")) {
                        refs.put(pos - 1, sb.toString());
                        break;
                    }
                    String prefix = pos + "=";
                    if (token.startsWith(prefix)) {
                        if (pos != 0) {
                            refs.put(pos - 1, sb.toString());
                            sb = new StringBuilder();
                        }
                        ++pos;
                        sb.append(token.substring(prefix.length()));
                        continue;
                    }
                    sb.append(token);
                }
                long num = -1L;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ("\n".equals(token = token.trim()) || "".equals(token)) continue;
                    if (token.endsWith("=")) {
                        num = Long.parseLong(token.substring(0, token.length() - 1));
                        HashSet substrs = new HashSet();
                        templates.put(num, substrs);
                        continue;
                    }
                    int from = -1;
                    int to = -1;
                    int ref = -1;
                    String man = null;
                    String doc = null;
                    long weight = -1L;
                    StringTokenizer st1 = new StringTokenizer(token, " ");
                    while (st1.hasMoreTokens()) {
                        String s = st1.nextToken();
                        if (from == -1) {
                            from = Integer.parseInt(s);
                            continue;
                        }
                        if (to == -1) {
                            to = Integer.parseInt(s);
                            continue;
                        }
                        if (ref == -1) {
                            ref = Integer.parseInt(s);
                            continue;
                        }
                        if (man == null) {
                            man = s;
                            continue;
                        }
                        if (doc == null) {
                            doc = s;
                            continue;
                        }
                        if (weight != -1L) continue;
                        weight = Long.parseLong(s);
                    }
                    if (from == -1 || man == null) continue;
                    Substr substr = new Substr(from, to, (String)refs.get(ref), weight, new DocURL(man, doc));
                    templates.get(num).add(substr);
                }
                is.close();
            }
            catch (Exception e) {
                System.err.println("Failed to read templates: " + e.getMessage());
            }
        }
        return templates;
    }

    public static Map<Long, Integer> getFrequencies() {
        if (frequencies == null) {
            frequencies = new HashMap<Long, Integer>();
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/frequencies.txt");
            try {
                if (u == null) {
                    u = Service.fileNameGitResource(HarvestDoc.class, "/oracle/dbtools/parser/plsql/doc/frequencies.txt");
                }
                InputStream is = u.openStream();
                StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    token = token.trim();
                    int pos = token.indexOf(61);
                    String head = token.substring(0, pos);
                    String tail = token.substring(pos + 1);
                    frequencies.put(Long.decode(head), Integer.decode(tail));
                }
                is.close();
            }
            catch (Exception e) {
                System.err.println("Failed to read frequnecies: " + e.getMessage());
            }
        }
        return frequencies;
    }

    public static Map<Integer, DocURL> getRailroads() {
        if (railroads.size() == 0) {
            URL u = HarvestDoc.class.getResource("/oracle/dbtools/parser/plsql/doc/railroad.txt");
            try {
                InputStream is = u.openStream();
                StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    token = token.trim();
                    int pos = token.indexOf(61);
                    String head = token.substring(0, pos);
                    String tail = token.substring(pos + 1);
                    if (tail.startsWith("SQL")) {
                        railroads.put(Integer.decode(head), new DocURL(DocURL.Manual.SQL, tail.substring(4)));
                        continue;
                    }
                    if (tail.startsWith("PLSQL")) {
                        railroads.put(Integer.decode(head), new DocURL(DocURL.Manual.PLSQL, tail.substring(6)));
                        continue;
                    }
                    if (tail.startsWith("SQLPLUS")) {
                        railroads.put(Integer.decode(head), new DocURL(DocURL.Manual.SQLPLUS, tail.substring("SQLPLUS".length() + 1)));
                        continue;
                    }
                    System.err.println("Unknown doc url: " + tail);
                }
                is.close();
            }
            catch (Exception e) {
                System.err.println("Failed to read railroad diagram URLs: " + e.getMessage());
            }
        }
        return railroads;
    }

    static String readURL(String masterBNFurl) throws Exception {
        if (masterBNFurl.endsWith(".pdf") || masterBNFurl.endsWith(".mobi") || masterBNFurl.endsWith(".epub")) {
            return "";
        }
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        URL url = new URL(masterBNFurl);
        System.out.print('.');
        BufferedInputStream bin = new BufferedInputStream(url.openStream());
        bytesRead = bin.read(bytes, 0, bytes.length);
        StringBuilder sb = new StringBuilder();
        while (bytesRead != -1) {
            String bytesStr = new String(bytes);
            int cut = bytesRead;
            if (bytesStr.length() < cut) {
                cut = bytesStr.length();
            }
            sb.append(bytesStr.substring(0, cut));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        bin.close();
        return sb.toString();
    }
}

