/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import oracle.dbtools.parser.json.Jsonable;

public class Util {
    static String specialEncoding = "^$%s%$^";

    public static String cleanText(String input) {
        String ret = input;
        if (ret.startsWith("\"")) {
            ret = ret.substring(1, ret.length() - 1);
        }
        ret = ret.replace("\\\\", specialEncoding);
        ret = ret.replace("\\\"", "\"");
        ret = ret.replace("\\r", "\r");
        ret = ret.replace("\\n", "\n");
        ret = ret.replace("\\t", "\t");
        ret = ret.replace("\\b", "\b");
        ret = ret.replace("\\f", "\f");
        ret = ret.replace(specialEncoding, "\\");
        return ret;
    }

    public static String unescape(String input) throws AssertionError {
        try {
            JsonFactory f = new JsonFactory();
            JsonParser p = f.createParser("\"" + input + "\"");
            JsonToken t = p.nextToken();
            return p.getText();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public static String sugarcoatText(String input) {
        if (input == null) {
            return null;
        }
        String ret = input;
        ret = ret.replace("\\", "\\\\");
        ret = ret.replace("\r", "\\r");
        ret = ret.replace("\n", "\\n");
        ret = ret.replace("\t", "\\t");
        ret = ret.replace("\b", "\\b");
        ret = ret.replace("\f", "\\f");
        ret = ret.replace("\"", "\\\"");
        StringBuilder b = new StringBuilder();
        for (char c : ret.toCharArray()) {
            if (c >= '\u0080') {
                b.append("\\u").append(String.format("%04X", c));
                continue;
            }
            if (c < ' ') {
                b.append('?');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String escape(String input) throws AssertionError {
        try {
            JsonFactory f = new JsonFactory();
            CharArrayWriter w = new CharArrayWriter();
            JsonGenerator g = f.createGenerator((Writer)w);
            g.writeString(input);
            g.close();
            String ret = ((Object)w).toString();
            if (ret.startsWith("\"")) {
                ret = ret.substring(1, ret.length() - 1);
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public static String toJson(Object message) {
        if (message == null) {
            return null;
        }
        if (message instanceof String && ((String)message).startsWith("\"")) {
            return (String)message;
        }
        if (message instanceof String && ((String)message).startsWith("{")) {
            return (String)message;
        }
        if (message instanceof String && ((String)message).startsWith("[")) {
            return (String)message;
        }
        if (message instanceof String && "OK".equals(message)) {
            return "\"" + String.valueOf(message) + "\"";
        }
        if (message instanceof String && "null".equals(message)) {
            return null;
        }
        if (message instanceof Jsonable) {
            return ((Jsonable)message).toJson();
        }
        if (message instanceof Jsonable[]) {
            Jsonable[] array = (Jsonable[])message;
            StringBuilder ret = new StringBuilder("[");
            int pos = 0;
            for (Jsonable elem : array) {
                if (0 < pos++) {
                    ret.append(',');
                }
                ret.append(elem.toJson());
            }
            ret.append(']');
            return ret.toString();
        }
        if (message instanceof Throwable) {
            return "\"" + ((Throwable)message).getMessage() + "\"";
        }
        throw new AssertionError((Object)("VT: Unrecognized message: " + String.valueOf(message)));
    }

    public static void main(String[] args) throws IOException {
        String value = "Hello \n\"World\"";
        System.out.println(Util.escape("Hello \n\"World\""));
        System.out.println(Util.sugarcoatText("Hello \n\"World\""));
        System.out.println(Util.unescape(Util.escape("Hello \n\"World\"")));
        System.out.println(Util.cleanText(Util.sugarcoatText("Hello \n\"World\"")));
    }
}

