/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.ParseNode;

class Sibling
extends Attribute {
    String ref;
    int shift;

    public Sibling(String name, int shift) {
        this.name = name;
        this.ref = Sibling.referredTo(name);
        this.shift = shift;
    }

    @Override
    Set<Tuple> eval(Map<String, Integer> attributePositions, Set<Tuple> candidates, ParseNode root) {
        int nameCol = attributePositions.get(this.name);
        int refCol = attributePositions.get(this.ref);
        for (Tuple t : candidates) {
            if (t.values[refCol] == null) continue;
            t.values[nameCol] = t.values[refCol].parent();
            if (t.values[nameCol] == null) continue;
            t.values[nameCol] = Sibling.getSibling(t.values[refCol], t.values[nameCol], this.shift);
        }
        return candidates;
    }

    @Override
    Attribute referredTo(Map<String, Attribute> varDefs) {
        return varDefs.get(this.ref);
    }

    @Override
    ParseNode lookup(Map<String, Integer> attributePositions, ParseNode[] tuple, Map<String, Attribute> varDefs) {
        ParseNode self = this.referredTo(varDefs).lookup(attributePositions, tuple, varDefs);
        if (self == null) {
            return null;
        }
        return Sibling.getSibling(self, self.parent(), this.shift);
    }
}

