/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.Map;

public class PredicateDependency {
    Map<String, Map<String, Boolean>> forward = new HashMap<String, Map<String, Boolean>>();
    Map<String, Map<String, Boolean>> backward = new HashMap<String, Map<String, Boolean>>();

    boolean isDependent(String ref, String def) {
        if (ref.equals(def)) {
            return true;
        }
        Map<String, Boolean> dependents = this.forward.get(ref);
        if (dependents == null) {
            return false;
        }
        return dependents.containsKey(def);
    }

    boolean isPositivelyDependent(String ref, String def) {
        Map<String, Boolean> dependents = this.forward.get(ref);
        if (dependents == null) {
            return false;
        }
        return Boolean.TRUE == dependents.get(def);
    }

    void addDependency(String ref, String def, boolean isPositive) {
        Map<String, Boolean> existing;
        Map<String, Boolean> bd = this.backward.get(def);
        if (bd == null) {
            bd = new HashMap<String, Boolean>();
            this.backward.put(def, bd);
        }
        bd.put(def, true);
        Map<String, Boolean> fr = this.forward.get(ref);
        if (fr == null) {
            fr = new HashMap<String, Boolean>();
            this.forward.put(ref, fr);
        }
        fr.put(ref, true);
        Map<String, Boolean> br = this.backward.get(ref);
        if (br == null) {
            br = new HashMap<String, Boolean>();
            this.backward.put(ref, br);
        }
        br.put(ref, true);
        Map<String, Boolean> fd = this.forward.get(def);
        if (fd == null) {
            fd = new HashMap<String, Boolean>();
            this.forward.put(def, fd);
        }
        fd.put(def, true);
        HashMap<String, HashMap<String, Boolean>> newForward = new HashMap<String, HashMap<String, Boolean>>();
        HashMap<String, HashMap<String, Boolean>> newBackward = new HashMap<String, HashMap<String, Boolean>>();
        for (String from : br.keySet()) {
            for (String to : fd.keySet()) {
                boolean p1 = br.get(from);
                boolean p2 = fd.get(to);
                HashMap<String, Boolean> dependents = (HashMap<String, Boolean>)newForward.get(from);
                if (dependents == null) {
                    dependents = new HashMap<String, Boolean>();
                    newForward.put(from, dependents);
                }
                dependents.put(to, p1 && isPositive && p2);
                HashMap<String, Boolean> referents = (HashMap<String, Boolean>)newBackward.get(to);
                if (referents == null) {
                    referents = new HashMap<String, Boolean>();
                    newBackward.put(to, referents);
                }
                referents.put(from, p1 && isPositive && p2);
            }
        }
        for (String key : newForward.keySet()) {
            existing = this.forward.get(key);
            if (existing == null) {
                this.forward.put(key, (Map)newForward.get(key));
                continue;
            }
            existing.putAll((Map)newForward.get(key));
        }
        for (String key : newBackward.keySet()) {
            existing = this.backward.get(key);
            if (existing == null) {
                this.backward.put(key, (Map)newBackward.get(key));
                continue;
            }
            existing.putAll((Map)newBackward.get(key));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String from : this.forward.keySet()) {
            for (String to : this.forward.get(from).keySet()) {
                sb.append(from + (this.forward.get(from).get(to) != false ? "+" : "-") + "->" + to + "\n");
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        PredicateDependency pd = new PredicateDependency();
        pd.addDependency("1", "2", true);
        pd.addDependency("2", "3", true);
        pd.addDependency("0", "1", true);
        pd.addDependency("2", "4", false);
        System.out.println(pd);
    }
}

