/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.False;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.True;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

class JavaFunc
implements Predicate {
    private String name;
    Object struct;
    List<String> args;
    public Method callback = null;

    public JavaFunc(String name, Object struct, List<String> args) {
        this.name = name;
        if (struct == null) {
            return;
        }
        this.struct = struct;
        this.args = args;
        Class<?> c = struct.getClass();
        try {
            try {
                this.callback = c.getDeclaredMethod(name, Map.class, ParseNode[].class, List.class);
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                this.callback = c.getMethod(name, Map.class, ParseNode[].class, List.class);
            }
            this.callback.setAccessible(true);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] t, List<LexerToken> src, Map<String, Attribute> varDefs) {
        try {
            Boolean ret = (Boolean)this.callback.invoke(this.struct, attributePositions, t, this.args);
            return ret;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String toString(int depth) {
        return "." + this.name;
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
    }

    @Override
    public void signature(Set<String> ret) {
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        return ret;
    }

    @Override
    public void adjustIsFunFlag(Set<String> independentAttributes) {
    }

    @Override
    public MaterializedPredicate eval(Parsed target) {
        try {
            Boolean ret = (Boolean)this.callback.invoke(this.struct, null, null, this.args);
            if (ret.booleanValue()) {
                return new True().eval(target);
            }
            return new False().eval(target);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

